package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 成本中心维护服务接口
*
* @author longde
* @since 2022-08-17
*/
@Api(tags = {"成本中心维护服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ICostCenterQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/costCenter",
    url = "${tcbj.center.report.api:}"
)
public interface ICostCenterQueryApi {

    /**
    * 根据id查询成本中心维护
    *
    * @param id 成本中心维护id
    * @return   成本中心维护数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询成本中心维护", notes = "根据id查询成本中心维护")
    RestResponse<CostCenterRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 成本中心维护分页数据
    *
    * @param filter   成本中心维护查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 成本中心维护分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "成本中心维护分页数据", notes = "根据filter查询条件查询成本中心维护数据，filter=CostCenterReqDto")
    RestResponse<PageInfo<CostCenterRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 逻辑仓分页数据
     *
     * @param reqDto   逻辑仓查询条件
     * @return 逻辑仓分页数据
     */
    @PostMapping("/post/page")
    @ApiOperation(value = "成本中心维护分页数据", notes = "成本中心维护分页数据，filter=LogicWarehouseReqDto")
    RestResponse<PageInfo<CostCenterRespDto>> queryByPageByPost(@RequestBody CostCenterReqDto reqDto);



}
