package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
* 批次调整单Eo对象
*
* @author yuangui
* @since 2022-04-26
*/
@ApiModel(value = "BatchAdjustmentOrderRespDto", description = "批次调整单Eo对象")
@Data
public class BatchAdjustmentOrderRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  批次调整单号
    */
    @ApiModelProperty(name = "orderNo", value = "批次调整单号")
    private String orderNo;
    /**
    *  业务类型：general_adjustment:普通调整
    */
    @ApiModelProperty(name = "businessType", value = "业务类型：general_adjustment:普通调整")
    private String businessType;
    /**
    *  单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过")
    private String orderStatus;
    /**
    *  是否同步wms：1是，0否
    */
    @ApiModelProperty(name = "synchronousWms", value = "是否同步wms：1是，0否")
    private Integer synchronousWms;
    /**
    *  逻辑仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "逻辑仓库ID")
    private Long warehouseId;
    /**
    *  逻辑仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;
    /**
    *  逻辑仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "逻辑仓库名称")
    private String warehouseName;
    /**
    *  总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
}
