package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 组合商品请求Dto
 *
 * @author haoyang
 * @date 2021/11/22 20:19
 * @since 0.1.0
 */
@ApiModel(value = "CombinedPackageActivityReqDto", description = "组合套装活动查询入参Dto")
public class CombinedPackageActivityReqDto {

    @ApiModelProperty(name = "shopId", value = "店铺id", required = true)
    private Long shopId;

    @ApiModelProperty(name = "pageNum", value = "当前页数", required = true)
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数", required = true)
    private Integer pageSize;

    @ApiModelProperty(name = "activityName",value = "套装活动名称")
    private String activityName;

    @ApiModelProperty(name = "mallType", value = "商城类型（1:H5商城，2:PC商城）")
    private Integer mallType = 1;

    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id")
    private Long activityTemplateId;

    @ApiModelProperty(name = "activityStatus", value = "活动状态")
    private String activityStatus;

    @ApiModelProperty(name = "customerIds", value = "客户Ids")
    private String customerIds;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "conditionTemplateId", value = "条件模板编号")
    private Long conditionTemplateId;

    @ApiModelProperty(name = "activityIds", value = "活动Ids")
    private List<Long> activityIds;

    @ApiModelProperty(name = "thirdPartyCode",value = "套装编码")
    private String thirdPartyCode;

    @ApiModelProperty(name = "thirdPartyCode",value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "thirdPartyCode",value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "activityId", value = "活动Id")
    private Long activityId;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Integer getMallType() {
        return mallType;
    }

    public void setMallType(Integer mallType) {
        this.mallType = mallType;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(String customerIds) {
        this.customerIds = customerIds;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getConditionTemplateId() {
        return conditionTemplateId;
    }

    public void setConditionTemplateId(Long conditionTemplateId) {
        this.conditionTemplateId = conditionTemplateId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public String getThirdPartyCode() {
        return thirdPartyCode;
    }

    public void setThirdPartyCode(String thirdPartyCode) {
        this.thirdPartyCode = thirdPartyCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
}
