/**
 * @(#) LogisticsInReportVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;

/**
 * LogisticsInReportRespDto
 */
@Data
@ApiModel(value = "LogisticsInReportRespDto", description = "")
public class LogisticsInReportRespDto   {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime = null;
  
  
  @ApiModelProperty(name="updateTime", value = "操作时间")
  @JsonProperty("updateTime")
  private String updateTime;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson = null;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson = null;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id = null;
  
  
  @ApiModelProperty(name="logisticsCompany", value = "物流公司")
  @JsonProperty("logisticsCompany")
  private String logisticsCompany;
  
  
  @ApiModelProperty(name="logisticsType", value = "承运方式")
  @JsonProperty("logisticsType")
  private String logisticsType;
  
  
  @ApiModelProperty(name="logisticsNo", value = "物流单号")
  @JsonProperty("logisticsNo")
  private String logisticsNo;
  
  
  @ApiModelProperty(name="wmsNo", value = "WMS单号")
  @JsonProperty("wmsNo")
  private String wmsNo;
  
  
  @ApiModelProperty(name="businessType", value = "关联业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="businessOrderNo", value = "关联业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;
  
  @Valid
  @ApiModelProperty(name="num", value = "数量")
  @JsonProperty("num")
  private Integer num;

  @ApiModelProperty(name="volume", value = "体积")
  @JsonProperty("volume")
  public BigDecimal volume;
  
  
  @ApiModelProperty(name="preArriveimeStart", value = "预计到达时间")
  @JsonProperty("preArriveimeStart")
  private Date preArriveimeStart;
  
  
  @ApiModelProperty(name="realArriveimeStart", value = "实际到达时间")
  @JsonProperty("realArriveimeStart")
  private Date realArriveimeStart;
  
  
  @ApiModelProperty(name="status", value = "状态")
  @JsonProperty("status")
  private String status;
  
  
  @ApiModelProperty(name="remark", value = "备注")
  @JsonProperty("remark")
  private String remark;
  
  
  @ApiModelProperty(name="receiptPicture", value = "回单图片")
  @JsonProperty("receiptPicture")
  private String receiptPicture;

  @ApiModelProperty(name="operInfo", value = "操作信息")
  @JsonProperty("operInfo")
  private String operInfo;

  @ApiModelProperty(name="operAddr", value = "操作地点")
  @JsonProperty("operAddr")
  private String operAddr;

  @ApiModelProperty(name="externalOrderNo", value = "外部订单号")
  @JsonProperty("externalOrderNo")
  private String externalOrderNo;

  @ApiModelProperty(name="overtimeFlag", value = "是否超时 0异常 1超时 2正常")
  @JsonProperty("overtimeFlag")
  private String overtimeFlag;

  @ApiModelProperty(name="preOrderNo", value = "前置单号")
  @JsonProperty("preOrderNo")
  private String preOrderNo;

  @ApiModelProperty(name="inPhysicsWarehouseCode", value = "入库物理仓编码")
  @JsonProperty("inPhysicsWarehouseCode")
  private String inPhysicsWarehouseCode;

  @ApiModelProperty(name="relevanceNo", value = "关联单号")
  @JsonProperty("relevanceNo")
  private String relevanceNo;

  @ApiModelProperty(name="consignee", value = "收货人")
  @JsonProperty("consignee")
  private String consignee;

  @ApiModelProperty(name="phone", value = "联系电话")
  @JsonProperty("phone")
  private String phone;

  @ApiModelProperty(name="address", value = "收货地址")
  @JsonProperty("address")
  private String address;


  @ApiModelProperty(
          name = "province",
          value = "省份名称"
  )
  private String province;
  @ApiModelProperty(
          name = "city",
          value = "城市名称"
  )
  private String city;
  @ApiModelProperty(
          name = "district",
          value = "区县名称"
  )
  private String district;

  @ApiModelProperty(name = "overtimeStatus",value = "超时状态")
  private String overtimeStatus;

  @ApiModelProperty(name = "overtimeStatus",value = "超时时间")
  private String overtime;

  @ApiModelProperty(name = "outPhysicsWarehouseName",value = "物理仓")
  private String outPhysicsWarehouseName;

  @ApiModelProperty(name = "customerCode",value = "客户编码")
  private String customerCode;

  @ApiModelProperty(name = "customerName",value = "客户名称")
  private String customerName;

  @ApiModelProperty(name = "outNoticeNo",value = "出库通知单")
  private String outNoticeNo;

}

