/**
 * @(#) InlineObject.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * LogisticsInReportReqDto
 */
@Data
public class LogisticsInReportReqDto extends BasePageDto {
  @NotNull 
  @ApiModelProperty(name="pageSize", required = true, value = "分页大小")
  @JsonProperty("pageSize")
  private Integer pageSize;
  
  @NotNull 
  @ApiModelProperty(name="pageNum", required = true, value = "当前页码")
  @JsonProperty("pageNum")
  private Integer pageNum;
  
  
  @ApiModelProperty(name="logisticsCompany", value = "物流公司")
  @JsonProperty("logisticsCompany")
  private String logisticsCompany;
  
  
  @ApiModelProperty(name="logisticsType", value = "承运方式")
  @JsonProperty("logisticsType")
  private String logisticsType;
  
  
  @ApiModelProperty(name="logisticsNo", value = "物流单号")
  @JsonProperty("logisticsNo")
  private String logisticsNo;
  
  
  @ApiModelProperty(name="wmSNo", value = "WMS单号")
  @JsonProperty("WMSNo")
  private String WMSNo;
  
  
  @ApiModelProperty(name="businessType", value = "关联业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="businessOrderNo", value = "关联业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;
  
  
  @ApiModelProperty(name="status", value = "状态")
  @JsonProperty("status")
  private String status;
  
  
  @ApiModelProperty(name="createTimeStart", value = "创建时间开始")
  @JsonProperty("createTimeStart")
  private String createTimeStart;
  
  
  @ApiModelProperty(name="createTimeEnd", value = "创建时间结束")
  @JsonProperty("createTimeEnd")
  private String createTimeEnd;
  
}

