package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerSalesmanRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 业务员表服务接口
*
* @author yuangui
* @since 2022-03-19
*/
@Api(tags = {"客户中心:PCP业务员表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ICustomerSalesmanQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v2/customer-salesman",
    url = "${tcbj.center.report.api:}"
)
public interface IPCPCustomerSalesmanQueryApi {

    /**
    * 根据id查询业务员表
    *
    * @param id 业务员表id
    * @return   业务员表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询业务员表", notes = "根据id查询业务员表")
    RestResponse<PCPCustomerSalesmanRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 业务员表分页数据
    *
    * @param filter   业务员表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 业务员表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "业务员表分页数据", notes = "根据filter查询条件查询业务员表数据，filter=CustomerSalesmanReqDto")
    RestResponse<PageInfo<PCPCustomerSalesmanRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
