package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.SortingExpenseDetailDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseDetailReportDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseDetailReportPageReqDto;
import com.dtyunxi.tcbj.api.dto.UpdateBillOrgDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.simpleframework.xml.core.Validate;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description 基线-报表中心-分拣计费明细报表服务接口
 * @Author 代码生成器
 * @Date 2025-08-26 14:59:24
 * @TemplateVersion 1.0.0
 * @MD5Code 15d3b14a91704f8ca1413cfdbd5e2a72
 **/
@Api(tags = {"基线-报表中心-分拣计费明细报表服务接口"})
@FeignClient(name = "${com.yunxi.dg.base.center.report.api.name:yunxi-dg-base-center-report}", url = "${com.yunxi.dg.base.center.report.api:}")
public interface ISortingExpenseDetailApi {
    @PostMapping(path = "/v1/sortingExpenseDetail/insert")
    @ApiOperation(value = "新增分拣计费明细报表数据", notes = "新增分拣计费明细报表数据")
    RestResponse<Long> insert(@RequestBody SortingExpenseDetailDto dto);

    @PostMapping(path = "/v1/sortingExpenseDetail/update")
    @ApiOperation(value = "更新分拣计费明细报表数据", notes = "更新分拣计费明细报表数据")
    RestResponse<Void> update(@RequestBody SortingExpenseDetailDto dto);

    @PostMapping(path = "/v1/sortingExpenseDetail/get/{id}")
    @ApiOperation(value = "根据id获取分拣计费明细报表数据", notes = "根据id获取分拣计费明细报表数据")
    RestResponse<SortingExpenseDetailDto> get(@PathVariable(name = "id", required = true) Long id);

    @PostMapping(path = "/v1/sortingExpenseDetail/logicDelete/{id}")
    @ApiOperation(value = "逻辑删除分拣计费明细报表数据", notes = "逻辑删除分拣计费明细报表数据")
    RestResponse<Void> logicDelete(@PathVariable(name = "id", required = true) Long id);

    @PostMapping(path = "/v1/sortingExpenseDetail/updateBillOrg/")
    @ApiOperation(value = "修改计费组织", notes = "修改计费组织")
    RestResponse<Void> updateBillOrg(@RequestBody @Validate UpdateBillOrgDto reqDto);

    @PostMapping(path = "/v1/sortingExpenseDetail/page")
    @ApiOperation(value = "分页查询分拣计费明细报表数据", notes = "分页查询分拣计费明细报表数据")
    RestResponse<PageInfo<SortingExpenseDetailReportDto>> page(@RequestBody SortingExpenseDetailReportPageReqDto dto);
}