package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 保费计费明细表服务接口
 */
@Api(tags = {"保费计费明细表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IReInsurancePremiumDetailQueryApi",
        name = "tcbj-center-report",
        path = "/v1/reInsurancePremiumDetail",
        url = "${tcbj.center.report.api:}"
)
public interface IReInsurancePremiumDetailQueryApi {

    /**
     * 根据id查询保费计费明细表
     *
     * @param id 保费计费明细表id
     * @return 保费计费明细表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询保费计费明细表", notes = "根据id查询保费计费明细表")
    RestResponse<ReInsurancePremiumDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 保费计费明细表分页数据
     *
     * @param filter   保费计费明细表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 保费计费明细表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "保费计费明细表分页数据", notes = "根据filter查询条件查询保费计费明细表数据，filter=ReInsurancePremiumReqDto")
    RestResponse<PageInfo<ReInsurancePremiumDetailRespDto>> queryByPage(@RequestBody ReInsurancePremiumDetailReqDto filter,
                                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 保费计费明细更新归档标识
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "保费计费明细更新归档标识", notes = "保费计费明细更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

    @PostMapping("/queryFlagCount")
    @ApiOperation(value = "保费计费明细异常统计", notes = "保费计费明细异常统计")
    RestResponse<ReInsuranceBillCountDto> queryFlagCount(@RequestBody ReInsurancePremiumDetailReqDto reqDto);

}
