package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "BatchInversionRespDto", description = "批次倒挂报表返回Dto")
public class BatchInversionRespDto extends BaseVo {
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    @ApiModelProperty(name = "brand", value = "品牌")
    private String brand;
    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;
    @ApiModelProperty(name = "oldWarehouseName", value = "各效期产品(最旧)|仓库")
    private String oldWarehouseName;
    @ApiModelProperty(name = "warehouseOnlineFlag", value = "线上线下")
    private String warehouseOnlineFlag;
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;
    @ApiModelProperty(name = "oldProduceTime", value = "各效期产品(最旧)|生产日期")
    private Date oldProduceTime;
    @ApiModelProperty(name = "oldBatch", value = "各效期产品(最旧)|批次")
    private String oldBatch;
    @ApiModelProperty(name = "oldBalance", value = "各效期产品(最旧)|即时库存")
    private BigDecimal oldBalance;
    @ApiModelProperty(name = "rdcProduceTime", value = "各仓发货批次(最新)|RDC仓生产日期")
    private Date rdcProduceTime;
    @ApiModelProperty(name = "rdcBatch", value = "各仓发货批次(最新)|RDC仓批次")
    private String rdcBatch;
    @ApiModelProperty(name = "zhProduceTime", value = "总仓发货批次(最新)|总仓生产日期")
    private Date zhProduceTime;
    @ApiModelProperty(name = "zhBatch", value = "总仓发货批次(最新)|总仓批次")
    private String zhBatch;
    @ApiModelProperty(name = "rdcInversion", value = "发货批次判断|RDC仓")
    private Integer rdcInversion;
    @ApiModelProperty(name = "zhInversion", value = "发货批次判断|总仓")
    private Integer zhInversion;
}
