/**
 * @(#) LogicalWarehouseVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 逻辑仓库实体
 */
@Data
@ApiModel(value = "LogicalWarehouseVO", description = "逻辑仓库实体")
public class LogicalWarehouseVO {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime;
  
  
  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id;
  
  
  @ApiModelProperty(name="warehouseId", value = "仓库ID")
  @JsonProperty("warehouseId")
  private String warehouseId;
  
  
  @ApiModelProperty(name="warehouseCode", value = "仓库编码")
  @JsonProperty("warehouseCode")
  private String warehouseCode;
  
  
  @ApiModelProperty(name="warehouseName", value = "仓库名称")
  @JsonProperty("warehouseName")
  private String warehouseName;
  
  
  @ApiModelProperty(name="warehouseType", value = "仓库类型")
  @JsonProperty("warehouseType")
  private String warehouseType;
  
  
  @ApiModelProperty(name="warehouseStatus", value = "仓库状态")
  @JsonProperty("warehouseStatus")
  private String warehouseStatus;
  
  
  @ApiModelProperty(name="warehouseAttr", value = "仓库属性")
  @JsonProperty("warehouseAttr")
  private String warehouseAttr;
  
  
  @ApiModelProperty(name="warehouseQuality", value = "仓库品质")
  @JsonProperty("warehouseQuality")
  private String warehouseQuality;
  
  
  @ApiModelProperty(name="easWarehouseId", value = " Eas仓库ID")
  @JsonProperty("easWarehouseId")
  private String easWarehouseId;
  
  
  @ApiModelProperty(name="ownPhysicalWarehouseId", value = "所属物理仓ID")
  @JsonProperty("ownPhysicalWarehouseId")
  private String ownPhysicalWarehouseId;
  
  
  @ApiModelProperty(name="ownPhysicalWarehouseName", value = "所属物理仓名称")
  @JsonProperty("ownPhysicalWarehouseName")
  private String ownPhysicalWarehouseName;

  @ApiModelProperty(name = "inQualifyWarehouse", value = "转合格入库仓")
  private String qualifiedWarehouse;

  @ApiModelProperty(name = "inQualifyWarehouseName", value = "转合格入库仓(名称)")
  private String qualifiedWarehouseName;

  @ApiModelProperty(name = "effectiveWarehouse", value = "近效期调入仓")
  private String effectiveWarehouse;

  @ApiModelProperty(name = "effectiveWarehouseName", value = "近效期调入仓(名称)")
  private String effectiveWarehouseName;

  @ApiModelProperty(name = "isReturn", value = "退货仓")
  private Integer isReturn;

  @ApiModelProperty(name = "switchLogicalWarehouse", value = "虚拟逻辑仓是否开启：1.开启，0.不开启（默认不开启）")
  private Integer switchLogicalWarehouse;
  
  /**
   * 货权组织ID
   */
  public enum CargoRightIdEnum {
    ADMIN("admin"),
    
    MANAGER("manager"),
    
    LEADER("leader");

    private String value;

    CargoRightIdEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CargoRightIdEnum fromValue(String value) {
      for (CargoRightIdEnum b : CargoRightIdEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  
  @ApiModelProperty(name="cargoRightId", value = "货权组织ID")
  @JsonProperty("cargoRightId")
  private String cargoRightId;
  
  
  @ApiModelProperty(name="cargoRightName", value = "货权组织名称")
  @JsonProperty("cargoRightName")
  private String cargoRightName;
  
  
  @ApiModelProperty(name="channelType", value = "渠道类型（线上/线下）")
  @JsonProperty("channelType")
  private String channelType;
  
  
  @ApiModelProperty(name="remark", value = "备注")
  @JsonProperty("remark")
  private String remark;
  
}

