/**
 * @(#) GetProductOrderListPageParams.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * GetProductOrderListPageParams
 */
@Data
@ApiModel(value = "ProductOrderLisReq", description = "")
public class ProductOrderLisReq {
  
  @ApiModelProperty(name="bussinessOrderNo", value = "单据编号")
  @JsonProperty("bussinessOrderNo")
  private String bussinessOrderNo;

  @ApiModelProperty(name="bussinessOrderNoList", value = "单据编号列表")
  @JsonProperty("bussinessOrderNoList")
  private List<String> bussinessOrderNoList;

  @ApiModelProperty(name="platformOrderNo ", value = "外部单号")
  @JsonProperty("platformOrderNo ")
  private String platformOrderNo ;

  
  @ApiModelProperty(name="bussinessOrderStatus", value = "单据状态")
  @JsonProperty("bussinessOrderStatus")
  private String bussinessOrderStatus;
  
  
  @ApiModelProperty(name="bussinessOrderType", value = "业务类型")
  @JsonProperty("bussinessOrderType")
  private String bussinessOrderType;
  @ApiModelProperty(name="orderType", value = "单据类型")
  @JsonProperty("orderType")
  private String orderType;
  
  @ApiModelProperty(name="receiveLogicalWarehouseCode", value = "收货逻辑仓编码")
  @JsonProperty("receiveLogicalWarehouseCode")
  private String receiveLogicalWarehouseCode;


  @ApiModelProperty(name="receiveLogicalWarehouseName", value = "收货逻辑仓名称")
  @JsonProperty("receiveLogicalWarehouseName")
  private String receiveLogicalWarehouseName;

  @ApiModelProperty(name="cargoName", value = "商品名称")
  @JsonProperty("cargoName")
  private String cargoName;
  @ApiModelProperty(name="startTime", value = "开始时间")
  @JsonProperty("startTime")
  private String startTime;
  
  
  @ApiModelProperty(name="endTime", value = "结束时间")
  @JsonProperty("endTime")
  private String endTime;
  
  
  @ApiModelProperty(name="pageNum", value = "")
  @JsonProperty("pageNum")
  private Integer pageNum;
  
  
  @ApiModelProperty(name="pageSize", value = "")
  @JsonProperty("pageSize")
  private Integer pageSize;

  @ApiModelProperty(name="longCode", value = "商品长编码")
  @JsonProperty("longCode")
  private String longCode;

  @ApiModelProperty(name="batch", value = "批次号")
  @JsonProperty("batch")
  private String batch;

  @ApiModelProperty(name="productionWorkshop", value = "生产车间")
  @JsonProperty("productionWorkshop")
  private String productionWorkshop;

  private List<String> outPhysicsWarehouseCodeList;
  
}

