package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderShipmentStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderShipmentStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsExtDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 销售订单发货服务接口
*
* @author 天泽
* @since 2022-08-24
*/
@Api(tags = {"销售订单发货服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ISalesOrderShipmentStatisticsQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/salesOrderShipmentStatistics",
    url = "${tcbj.center.report.api:}"
)
public interface ISalesOrderShipmentStatisticsQueryApi {

    /**
    * 根据id查询销售订单发货
    *
    * @param id 销售订单发货id
    * @return   销售订单发货数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询销售订单发货", notes = "根据id查询销售订单发货")
    RestResponse<SalesOrderShipmentStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 销售订单发货分页数据
    *
    * @param filter   销售订单发货查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 销售订单发货分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "销售订单发货分页数据", notes = "根据filter查询条件查询销售订单发货数据，filter=SalesOrderShipmentStatisticsReqDto")
    RestResponse<PageInfo<SalesOrderShipmentStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 销售订单发货统计
     * @param queryDto
     * @return
     */
    @PostMapping("/salesOrderShipmentStatistics")
    @ApiOperation(value = "销售订单发货统计", notes = "销售订单发货统计，SalesOrderStatisticsQueryDto")
    RestResponse<SalesOrderStatisticsExtDto> salesOrderShipmentStatistics(@RequestBody SalesOrderStatisticsQueryDto queryDto);


    @PostMapping("/salesOrderNutritionistStatistics")
    @ApiOperation(value = "销售订单营养家和其他出库发货统计", notes = "销售订单营养家和其他出库发货统计，SalesOrderStatisticsQueryDto")
    RestResponse<SalesOrderStatisticsExtDto> salesOrderNutritionistStatistics(@RequestBody SalesOrderStatisticsQueryDto queryDto);

    @PostMapping("/querySyncSalesOrderNutritionist")
    @ApiOperation(value = "销售订单营养家统计定时任务", notes = "销售订单营养家统计定时任务")
    RestResponse<Void> querySyncSalesOrderNutritionist(@RequestBody SalesOrderStatisticsQueryDto queryDto);

    @PostMapping("/querySyncOtherDeliveryOrder")
    @ApiOperation(value = "其他出库单统计定时任务", notes = "销售订单营养家统计定时任务")
    RestResponse<Void> querySyncOtherDeliveryOrder(@RequestBody SalesOrderStatisticsQueryDto queryDto);

}
