package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FinLogisticsReportDto", description = "物流运费合计记录Dto对象")
public class FinLogisticsReportDto extends RequestDto {
    /**
     *  主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     *  类型
     */
    @ApiModelProperty(name = "type", value = "类型")
    private String type;
    /**
     *  出库时间
     */
    @ApiModelProperty(name = "outboundTime", value = "出库时间")
    private Date outboundTime;

    /**
     *  出库通知单号
     */
    @ApiModelProperty(name = "outNoticeCode", value = "出库通知单号")
    private String outNoticeCode;

    /**
     *  出库结果单号
     */
    @ApiModelProperty(name = "outResultCode", value = "出库结果单号")
    private String outResultCode;

    /**
     *  出库单号
     */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;
    /**
     *  wms出库单号
     */
    @ApiModelProperty(name = "wmsOutboundCode", value = "wms出库单号")
    private String wmsOutboundCode;
    /**
     *  关联业务单号
     */
    @ApiModelProperty(name = "businessCode", value = "关联业务单号")
    private String businessCode;
    /**
     *  仓库
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库")
    private String warehouseName;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     *  物流公司
     */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;

    @ApiModelProperty(name = "logisticCompanyCode", value = "物流公司编码")
    private String logisticCompanyCode;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
     *  托运单号
     */
    @ApiModelProperty(name = "transportCode", value = "托运单号")
    private String transportCode;
    /**
     *  瓶数
     */
    @ApiModelProperty(name = "bottle", value = "瓶数")
    private BigDecimal bottle;
    /**
     *  箱数
     */
    @ApiModelProperty(name = "box", value = "箱数")
    private BigDecimal box;
    /**
     *  体积（m^3）
     */
    @ApiModelProperty(name = "volume", value = "体积（m^3）")
    private BigDecimal volume;
    /**
     *  重量（KG）
     */
    @ApiModelProperty(name = "weight", value = "重量（KG）")
    private BigDecimal weight;
    /**
     *  累计箱数
     */
    @ApiModelProperty(name = "totalBox", value = "累计箱数")
    private BigDecimal totalBox;
    /**
     *  累计体积（m^3）
     */
    @ApiModelProperty(name = "totalVolume", value = "累计体积（m^3）")
    private BigDecimal totalVolume;
    /**
     *  累计重量（KG）
     */
    @ApiModelProperty(name = "totalWeight", value = "累计重量（KG）")
    private BigDecimal totalWeight;
    /**
     *  合同模板编码(原名计算方式)，新计费方式需通过chargeMode判断是否件/体积，若是则判断pieceVolume，否则使用枚举ChargeModeEnum的defaultUnitName
     */
    @ApiModelProperty(name = "chargeMode", value = "合同模板编码(原名计算方式)")
    private String chargeMode;
    @ApiModelProperty(name = "calUnitName", value = "精准计费方式")
    private String calUnitName;
    /**
     *  运费单价
     */
    @ApiModelProperty(name = "transportPrice", value = "运费单价")
    private BigDecimal transportPrice;
    /**
     *  运费金额
     */
    @ApiModelProperty(name = "transportAmount", value = "运费金额")
    private BigDecimal transportAmount;
    /**
     *  运费单价
     */
    @ApiModelProperty(name = "minCharge", value = "最低费用")
    private BigDecimal minCharge;
    /**
     *  送货费
     */
    @ApiModelProperty(name = "deliveryAmount", value = "送货费")
    private BigDecimal deliveryAmount;
    /**
     *  卸货费
     */
    @ApiModelProperty(name = "unloadAmount", value = "卸货费")
    private BigDecimal unloadAmount;
    /**
     *  油价联动
     */
    @ApiModelProperty(name = "oilPrice", value = "油价联动")
    private BigDecimal oilPrice;
    /**
     * 运费金额*运费调整幅度
     */
    @ApiModelProperty(name = "oilTotalPrice", value = "油价总金额")
    private BigDecimal oilTotalPrice;
    /**
     *  特殊费用类型
     */
    @ApiModelProperty(name = "specialType", value = "特殊费用类型")
    private String specialType;
    /**
     *  特殊费用
     */
    @ApiModelProperty(name = "specialAmount", value = "特殊费用")
    private BigDecimal specialAmount;
    /**
     *  运费合计
     */
    @ApiModelProperty(name = "totalTransportAmount", value = "运费合计")
    private BigDecimal totalTransportAmount;
    /**
     *  分摊费用
     */
    @ApiModelProperty(name = "shareAmount", value = "分摊费用")
    private BigDecimal shareAmount;
    /**
     *  调出仓库
     */
    @ApiModelProperty(name = "warehouseOut", value = "调出仓库")
    private String warehouseOut;
    /**
     *  调出组织
     */
    @ApiModelProperty(name = "organizationOut", value = "调出组织")
    private String organizationOut;
    /**
     *  调入仓库
     */
    @ApiModelProperty(name = "warehouseEnter", value = "调入仓库")
    private String warehouseEnter;
    /**
     *  调入组织
     */
    @ApiModelProperty(name = "organizationEnter", value = "调入组织")
    private String organizationEnter;
    /**
     *  费用归属
     */
    @ApiModelProperty(name = "amountAttribution", value = "费用归属")
    private String amountAttribution;
    /**
     *  收获人
     */
    @ApiModelProperty(name = "harvestPeople", value = "收获人")
    private String harvestPeople;
    /**
     *  省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    @ApiModelProperty(name = "provinceCode", value = "省份Code")
    private String provinceCode;
    /**
     *  城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    @ApiModelProperty(name = "cityCode", value = "城市Code")
    private String cityCode;
    /**
     * 区/县
     */
    @ApiModelProperty(name = "area", value = "区/县")
    private String area;
    @ApiModelProperty(name = "areaCode", value = "区/县Code")
    private String areaCode;
    /**
     *  客户收获地址
     */
    @ApiModelProperty(name = "harvestAddress", value = "客户收获地址")
    private String harvestAddress;
    /**
     * 经纬度
     */
    @ApiModelProperty(name = "lngLat", value = "经纬度,以,分割")
    private String lngLat;
    /**
     * 状态（0=正常 1=异常）
     */
    @ApiModelProperty(name = "status", value = "状态（0=正常 1=异常）")
    private Integer status;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 分组后的明细id
     */
    @ApiModelProperty(name = "finLogisticsReportDtos", value = "finLogisticsReportDtos")
    private List<FinLogisticsReportDto> finLogisticsReportDtos;

    @ApiModelProperty(name = "logisticsModeId", value = "物流费用模板")
    private Long logisticsModeId;

    @ApiModelProperty(name = "logisticsTemplateArea", value = "物流模版区域")
    private String logisticsTemplateArea;

    @ApiModelProperty(name = "logisticsTemplateId", value = "物流模版ID")
    private Long logisticsTemplateId;

    @ApiModelProperty(name = "contractOilPrice", value = "合同基准油价")
    private BigDecimal contractOilPrice;

    @ApiModelProperty(name = "linkOilPrice", value = "联动油价")
    private BigDecimal linkOilPrice;

    @ApiModelProperty(name = "rangeOilPrice", value = "油价幅度")
    private String rangeOilPrice;

    @ApiModelProperty(name = "adjustOilPrice", value = "运费调整幅度")
    private BigDecimal adjustOilPrice;

    @ApiModelProperty(name = "transportNo", value = "承运单号")
    private String transportNo;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表记录id")
    private Long linkDailyReportId;

    private String warehouseEnterCode;
    private String warehouseOutCode;


    /**
     * 物流费合同ID
     */
    private Long contractId;

    private Long reportId;

    /**
     * 和票分摊比例；
     */
    private BigDecimal ratio;

    /**
     * 按件/体积  piece 件  volume 体积；
     */
    private String pieceVolume;
    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 开单日期
     */
    private String billingDate;
    /**
     * 记账日期
     */
    private String bookkeepingDate;
    /**
     * 城市级别
     */
    private String cityLevel;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 客户名称
     */
    private String easNo;

    /**
     * 物流费用模版
     */
    private LogisticRecordQueryRespDto logisticsTemplate;
    /**
     * 联动油价
     */
    private OilLinkQueryRespDto oilLinkQueryRespDto;
    /**
     * 物流模版区域信息
     */
    private AppointAreaQueryRespDto appointAreaQueryRespDto;

    /**
     * 是否参与合单
     */
    private Boolean ifMerge = true;

    /**
     * 合单角色 0：不参与合单 1：中心点 2：计算点
     */
    private Integer mergeRole = 0;

    //OCS内部运单号
    private String ocsConsignmentNo;
    //物流商管理的客户名称
    private String customerStr;

    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
    private String joinMergeDocumentNo;

    private String shopName;

    private String shopCode;

    /**
     * 异常原因
     */
    private String abnormalCauses;
    private String warehouseId;
    private String logisticId;
    private String mergeCode;
    public String getUniqueKey(){
        String day = "";
        if (this.getOutboundTime()!=null){
            day = DateUtil.getDateFormat(this.getOutboundTime(), DateUtil.YMD_DATA);
        }
        return String.format("%s,%s,%s,%s,%s,%s,%s",day,this.getWarehouseName(),this.getLogisticCompany(),this.getTransportType(),this.getProvinceCode(),this.getCityCode(),this.getAreaCode());
    }

    public String soleKey(){
        return this.getOutboundCode()+"_"+this.getOcsConsignmentNo();
    }

    public String soleKeyNew() {
        return this.getOutboundCode() + "_" + this.getWmsOutboundCode();
    }
}
