package com.dtyunxi.tcbj.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 快递账单查询参数
 *
 * @author buqi
 * @since 2024/12/04
 */
@Data
public class ExpressBillQueryDto implements Serializable {

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页大小")
    private Integer pageSize;

    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;

    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private List<String> warehouseCodeList;

    @ApiModelProperty(name = "billingOrgList", value = "计费组织集合")
    private List<String> billingOrgList;

    @ApiModelProperty(name = "logisticsCodeList", value = "物流公司编码集合")
    private List<String> logisticsCodeList;

    @ApiModelProperty(name = "transportTypeList", value = "承运方式集合")
    private List<String> transportTypeList;
}
