package com.dtyunxi.tcbj.api.dto;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * 销售单合单数据DTO
 * @author jiejun
 */
@Getter
@Setter
public class SaleOrderMergeDataDto extends BaseRespDto {

    @ApiModelProperty(name = "mergeOrder", value = "合单号")
    private String mergeOrder;

    @ApiModelProperty(name = "platformOrder", value = "渠道单号")
    private String platformOrder;

    @ApiModelProperty(name = "saleOrder", value = "销售单号（多个逗号隔开）")
    private String saleOrder;

    @ApiModelProperty(name = "pushDate", value = "推送时间")
    private Date pushDate;

    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓库名称")
    private String physicsWarehouseName;

    @ApiModelProperty(name = "consignmentNo", value = "托运单")
    private String consignmentNo;

    @ApiModelProperty(name = "ifTag", value = "是否有合单标签")
    private String ifTag;

    @ApiModelProperty(name = "tagCode", value = "标签编码")
    private String tagCode;

    @ApiModelProperty(name = "saleOrderTypeList", value = "业务类型")
    private List<String> saleOrderTypeList;

    private Integer pageNum = 1;
    private Integer pageSize = 10;
    private Date createTimeStart;//创建时间开始
    private Date createTimeEnd;//创建时间结束

}
