        package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.ExampleRespDto;
import com.github.pagehelper.PageInfo;
import com.dtyunxi.tcbj.api.dto.request.ExampleQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExampleRespDto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.cloud.openfeign.SpringQueryMap;

/**
 * TODO 该类及类中的方法仅做示例，测试及上线阶段请自行删除，请勿在该类中编写真实的业务代码。
 * <p>
 * API查询接口类（示例）
 * <p>
 * 规范要求： 1.类名命名规范： 接口以单词 [I] 开头，以单词 [Api] 结尾；实现类以 [Impl] 结尾； 查询接口与增删改接口分开，查询接口在单词 [Api] 前加 [Query] 标识该接口是个查询接口。
 * <p>
 * 2.方法命名： 接口名称采用驼峰格式命名方式，方法名称要准确表达该方法所处理的业务逻辑。 ◆ 新增接口 - 以单词 [add] 为前缀。 ◆ 修改接口 - 以单词 [modify] 为前缀。 ◆ 删除接口 - 以单词 [remove]
 * 为前缀。 ◆ 增/删接口 - 以单词 [save] 为前缀。(如果存在则update，不存在则新增)
 * <p>
 * 3.接口返回类型： 所有接口都返回类型都应是 RestResponse
 *
 * @author 书生
 * @since 1.0.0
 */
@Api(tags = {"报表中心：查询服务接口"})
@FeignClient(
        name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",
        path = "/v1/example",
        url = "${com.dtyunxi.tcbj.api:}"
)
public interface IExampleQueryApi {

    /**
     * 根据ID主键查询
     *
     * @param id 主键
     * @return RestResponse<ExampleDto>
     */
    @RequestMapping(value = {"/{id}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据ID查询详情", notes = "根据ID查询详情")
    RestResponse<ExampleRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页查询列表
     *
     * @param queryReqDto 查询参数
     * @param pageNum     分页页码
     * @param pageSize    分页行数
     * @return RestResponse<PageInfo       <       ExampleDto>>
     */
    @RequestMapping(value = {""}, produces = "application/json", method = RequestMethod.GET)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "queryReqDto", value = "查询参数", dataType = "com.dtyunxi.tcbj.api.dto.request.ExampleQueryReqDto", paramType = "query")
            ,
            @ApiImplicitParam(name = "pageNum", value = "当前页码", dataType = "integer", paramType = "query")
            ,
            @ApiImplicitParam(name = "pageSize", value = "分页行数", dataType = "integer", paramType = "query")
    })
    @ApiOperation(value = "分页查询列表", notes = "分页查询列表")
    RestResponse<PageInfo<ExampleRespDto>> queryByPage(@SpringQueryMap ExampleQueryReqDto queryReqDto,
                                                       @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                       @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
