package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.PlatformOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.PlatformOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 平台订单表服务接口
*
* @author haoxiao
* @since 2022-03-10
*/
@Api(tags = {"平台订单报表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/platformOrderReport", url = "${tcbj.center.report.api:}")
public interface IPlatformOrderReportQueryApi {

    /**
    * 平台订单表分页数据
    *
    * @param filter   平台订单表查询条件
    * @return 平台订单表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "平台订单分页数据", notes = "根据filter查询条件查询平台订单表数据，filter=PlatformOrderReqDto")
    RestResponse<PageInfo<PlatformOrderRespDto>> queryByPage(@RequestBody PlatformOrderReqDto filter);

    /**
     * 平台订单统计数据
     *
     * @param filter   平台订单表查询条件
     * @return 平台订单表分页数据
     */
    @PostMapping("/queryByCount")
    @ApiOperation(value = "平台订单统计数据", notes = "根据filter查询条件查询平台订单统计数据，filter=PlatformOrderReqDto")
    RestResponse<PlatformOrderCountRespDto> queryByCount(@RequestBody PlatformOrderReqDto filter);
}
