package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 放行单服务接口
*
* @author 紫霄
* @since 2023-05-11
*/
@Api(tags = {"放行单服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IInspectionReleaseOrderApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/inspectionReleaseOrder",
    url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleaseOrderApi {

/**
* 新增放行单
*
* @param addReqDto 放行单请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增放行单", notes = "新增放行单")
RestResponse<Long> addInspectionReleaseOrder(@RequestBody InspectionReleaseOrderReqDto addReqDto);

    /**
    * 修改放行单
    *
    * @param modifyReqDto 放行单请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改放行单", notes = "修改放行单")
    RestResponse<Void> modifyInspectionReleaseOrder(@RequestBody InspectionReleaseOrderReqDto modifyReqDto);

    /**
    * 删除放行单
    *
    * @param ids        放行单删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除放行单", notes = "删除放行单")
    RestResponse<Void> removeInspectionReleaseOrder(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
