package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据大屏-超时在途数据统计
 *
 * @author: cijian
 * @version: 1.0
 * @date 2022/12/28 9:52
 */
@Data
@ApiModel(value = "LogisticsStatisticsRespDto", description = "超时在途数据统计")
public class LogisticsStatisticsRespDto extends BaseVo {
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name="shippingCompanyCode", value = "物流公司编码")
    @JsonProperty("shippingCompanyCode")
    private String shippingCompanyCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty(name="shippingCompany", value = "物流公司名称")
    @JsonProperty("shippingCompany")
    private String shippingCompany;
    /**
     * 运输方式
     */
    @ApiModelProperty(name="shippingType", value = "运输方式")
    @JsonProperty("shippingType")
    private String shippingType;
    /**
     * 异常数量
     */
    @ApiModelProperty(name="errorNum", value = "异常数量")
    @JsonProperty("errorNum")
    private Integer errorNum;
    /**
     * 在途超时未签收数量
     */
    @ApiModelProperty(name="overtimeUnReceiptNum", value = "在途超时未签收数量")
    @JsonProperty("overtimeUnReceiptNum")
    private Integer overtimeUnReceiptNum;
    /**
     * 超时已签收数量
     */
    @ApiModelProperty(name="overtimeReceiptNum", value = "超时已签收数量")
    @JsonProperty("overtimeReceiptNum")
    private Integer overtimeReceiptNum;
}
