package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
* 渠道仓库存表Eo对象
*
* @author wude
* @since 2022-03-09
*/
@ApiModel(value = "ChannelInventoryReqDto", description = "渠道仓库存表Eo对象")
@Getter
@Setter
public class ChannelInventoryReqDto extends BaseDto {
    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     *  实际库存大于0
     */
    @ApiModelProperty(name = "positiveBalance", value = "实际库存大于0 0否 1是")
    private Integer positiveBalance;

    @ApiModelProperty(
            name = "longCodeList",
            value = "商品长编码集合"
    )
    private List<String> longCodeList;

    @ApiModelProperty(
            name = "warehouseCodeList",
            value = "物理仓编码集合"
    )
    private List<String> warehouseCodeList;

}
