package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderShipmentStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderShipmentStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 销售订单发货服务接口
*
* @author 天泽
* @since 2022-08-24
*/
@Api(tags = {"销售订单发货服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ISalesOrderShipmentStatisticsApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/salesOrderShipmentStatistics",
    url = "${tcbj.center.report.api:}"
)
public interface ISalesOrderShipmentStatisticsApi {

/**
* 新增销售订单发货
*
* @param addReqDto 销售订单发货请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增销售订单发货", notes = "新增销售订单发货")
RestResponse<Long> addSalesOrderShipmentStatistics(@RequestBody SalesOrderShipmentStatisticsReqDto addReqDto);

    /**
    * 修改销售订单发货
    *
    * @param modifyReqDto 销售订单发货请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改销售订单发货", notes = "修改销售订单发货")
    RestResponse<Void> modifySalesOrderShipmentStatistics(@RequestBody SalesOrderShipmentStatisticsReqDto modifyReqDto);

    /**
    * 删除销售订单发货
    *
    * @param ids        销售订单发货删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除销售订单发货", notes = "删除销售订单发货")
    RestResponse<Void> removeSalesOrderShipmentStatistics(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
