package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SecurityCodeReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.SecurityCodeReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.lang.reflect.InvocationTargetException;

@Api(tags = {"防伪码报表"})
@FeignClient(
        name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",
        path = "/v1/report",
        url = "${tcbj.center.report.api:}"
)
public interface SecurityCodeReportApi {
    @ApiOperation(
        tags = { "reportCenter/finishedGoodsInventory/securityCodeReport" },
        value = "防伪码报表分页列表",
        nickname = "getSecurityCodeReportListPage",
        notes = "防伪码报表"
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/finishedGoodsInventory/securityCodeReport",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<SecurityCodeReportRespDto>> getSecurityCodeReportListPage(
              @RequestBody(required = false) SecurityCodeReportReqDto securityCodeReportReqDto

    );

    @ApiOperation(
            tags = { "reportCenter/finishedGoodsInventory/securityCodeReport/generate" },
            value = "防伪码报表数据生成",
            nickname = "getSecurityCodeReportListPage",
            notes = "防伪码报表数据生成"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/report/finishedGoodsInventory/securityCodeReport"
    )
    RestResponse<Void> generateSecurityCodeReport();
}
