package com.dtyunxi.tcbj.api.dto.constant.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

public enum CsWarehouseClassifyEnum {

    /**
     * 物理仓
     **/
    PHYSICS("physics", "物理仓"),

    /**
     * 逻辑仓
     **/
    LOGIC("logic", "逻辑仓"),

    /**
     * 虚拟仓
     **/
    VIRTUAL("virtual", "虚拟仓"),

    /**
     * 渠道仓
     **/
    CHANNEL("channel", "渠道仓"),

    /**
     * 在途仓
     **/
    IN_TRANSIT("in_transit", "在途仓"),
    ;

    /**
     * 编码
     **/
    private String code;

    /**
     * 描述
     **/
    private String desc;

    CsWarehouseClassifyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsWarehouseClassifyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsWarehouseClassifyEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }

    public static String getDescByCode(String code) {
        for (CsWarehouseClassifyEnum value : CsWarehouseClassifyEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }
}