package com.dtyunxi.tcbj.api.dto.constant.enums;

import com.google.common.collect.Maps;

import java.util.Map;

public interface InspectionReleaseConstant {

    String PASS = "合格";


    /**
     * 放行单状态 0:预放行, 1:已放行, 2:不合格, 3:已撤销
     */
    abstract class ORDER_STATUS {
        public static final int ERROR = -99;
        public static final int PRE_EXECUTE = -1;
        public static final int PRE_RELEASE = 0;
        public static final int HAS_RELEASE = 1;
        public static final int NO_PASS = 2;
        public static final int HAS_BACK = 3;

        public static Map<Integer, String> valueMap = Maps.newHashMap();

        static {
            valueMap.put(ERROR, "放行异常");
            valueMap.put(PRE_EXECUTE, "准备执行");
            valueMap.put(PRE_RELEASE, "预放行");
            valueMap.put(HAS_RELEASE, "已放行");
            valueMap.put(NO_PASS, "不合格");
            valueMap.put(HAS_BACK, "已撤销");
        }
    }

    /**
     * 运单类型：1:预放行 2:正常放行
     */
    abstract class TYPE {
        public static final int PRE_RELEASE = 1;
        public static final int COMMON_RELEASE = 2;

        public static final int AUTO = 3;

        public static Map<Integer, String> valueMap = Maps.newHashMap();

        static {
            valueMap.put(PRE_RELEASE, "预放行");
            valueMap.put(COMMON_RELEASE, "正常放行");
            valueMap.put(AUTO, "自动放行");
        }
    }

    abstract class LOG_OPERATE {

        public static final String PASS_RELEASE = "pass_release";

        public static final String CANCEL_RELEASE = "cancel_release";

        public static final String CREATE_RELEASE_TASK = "create_release_task";

        public static final String DO_RELEASE_TASK = "do_release_task";

        public static final String RECEIVE_REPORT_PASS = "receive_report_pass";

        public static final String IMPORT_PLANNED_RELEASE_QUANTITY = "import_planned_release_quantity";

        public static final String IMPORT_QUALITY_INSPECTION_REPORT = "import_quality_inspection_report";

        public static Map<String, String> valueMap = Maps.newHashMap();

        static {
            valueMap.put(PASS_RELEASE, "放行");
            valueMap.put(CANCEL_RELEASE, "撤回放行");
            valueMap.put(CREATE_RELEASE_TASK, "创建放行任务");
            valueMap.put(DO_RELEASE_TASK, "执行放行任务");
            valueMap.put(RECEIVE_REPORT_PASS, "执行放行任务");
            valueMap.put(IMPORT_PLANNED_RELEASE_QUANTITY,"导入计划放行数量");
            valueMap.put(IMPORT_QUALITY_INSPECTION_REPORT,"导入质检报告");
        }

    }

    abstract class TASK_ITEM_TYPE {
        public static final String INSPECTION = "inspection";

        public static final String INTRANSIT_INSPECTION = "intransit_inspection";

        public static Map<String, String> valueMap = Maps.newHashMap();

        static {
            valueMap.put(INSPECTION, "待检仓放行任务");
            valueMap.put(INTRANSIT_INSPECTION, "待检在途仓放行任务");
        }
    }

    abstract class INSPECTION_TASK_STEP {
        public static final String EXECUTE_TRANSFER = "execute_transfer";

        public static final String CANCEL_WMS_NOTICE = "cancel_wms_notice";

        public static final String EXECUTE_ADJUST = "execute_adjust";

        public static final String MODIFY_NOTICE_SEND_WMS = "modify_notice_send_wms";
    }

    abstract class TASK_STATUS {

        public static final String WAIT_EXEC = "wait_exec";
        public static final String ING = "ing";

        public static final String ERROR = "error";

        public static final String END = "end";

        public static final String REPAIR = "repair";

        public static Map<String, String> valueMap = Maps.newHashMap();

        static {
            valueMap.put(WAIT_EXEC, "待执行");
            valueMap.put(ING, "进行中");
            valueMap.put(ERROR, "执行失败");
            valueMap.put(END, "已完成");
            valueMap.put(REPAIR, "已修复");
        }
    }

}
