package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;

import com.dtyunxi.dto.BasePageDto;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
* 逻辑仓Eo对象
*
* @author wude
* @since 2022-03-07
*/
@ApiModel(value = "LogicWarehouseReqDto", description = "逻辑仓Eo对象")
@Getter
@Setter
public class LogicWarehouseReqDto extends BasePageDto {
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "physicsWarehouseNameList", value = "物理仓库名称集合")
    private List<String> physicsWarehouseNameList;
    /**
    *  仓库类型,待定
    */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型,待定")
    private String warehouseType;


    private String warehouseQuality;
    /**
    *  仓库状态 initial-初始,enable-启用,disable-停用
    */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-启用,disable-停用")
    private String warehouseStatus;
    /**
    *  spa工厂
    */
    @ApiModelProperty(name = "sapFactory", value = "spa工厂")
    private String sapFactory;
    /**
    *  sap库位
    */
    @ApiModelProperty(name = "sapStorageLocation", value = "sap库位")
    private String sapStorageLocation;
    /**
    *  是否允许负库存 0-不允许 1-允许
    */
    @ApiModelProperty(name = "negativeFlag", value = "是否允许负库存 0-不允许 1-允许")
    private Integer negativeFlag;
    /**
    *  渠道类型
    */
    @ApiModelProperty(name = "channelType", value = "渠道类型")
    private String channelType;
    /**
    *  联系人
    */
    @ApiModelProperty(name = "contact", value = "联系人")
    private String contact;
    /**
    *  联系电话
    */
    @ApiModelProperty(name = "phone", value = "联系电话")
    private String phone;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;

    /**
     *  组织ID集合
     */
    @ApiModelProperty(name = "organizationIds", value = "组织ID")
    private List<Long> organizationIds;

    /**
     *  组织ID集合
     */
    @ApiModelProperty(name = "physicsWarehouseCodes", value = "物理仓库编码集合")
    private List<String> physicsWarehouseCodes;

    @ApiModelProperty(name = "warehouseCodes", value = "仓库编码集合")
    private List<String> warehouseCodes;
    @ApiModelProperty(name = "warehouseNames", value = "仓库名称集合")
    private List<String> warehouseNames;

    /**
     *  组织code
     */
    @ApiModelProperty(name = "organizationCodeList", value = "组织code集合")
    private List<String> organizationCodeList;
    /**
    *  所属组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;
    /**
    *  是否主仓：0否1是
    */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;
    @ApiModelProperty(name = "subordinateLogicWarehouseId")
    private Long subordinateLogicWarehouseId;

    /**
     *  组织code
     */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
}
