package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;

/**
* 调拨单表Eo对象
*
* @author by_liusong
* @since 2022-08-26
*/
@ApiModel(value = "TransferOrderRespDto", description = "调拨单表Eo对象")
public class TransferOrderRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  调拨单号
    */
    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;
    /**
    *  前置单号 
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号 ")
    private String preOrderNo;
    /**
    *  外部采购单号
    */
    @ApiModelProperty(name = "externalPurchaseOrderNo", value = "外部采购单号")
    private String externalPurchaseOrderNo;
    /**
    *  外部销售单号
    */
    @ApiModelProperty(name = "externalSaleOrderNo", value = "外部销售单号")
    private String externalSaleOrderNo;
    /**
    *  调拨单类型
    */
    @ApiModelProperty(name = "type", value = "调拨单类型")
    private String type;
    /**
    *  PCP,EAS等
    */
    @ApiModelProperty(name = "orderSrc", value = "PCP,EAS等")
    private String orderSrc;
    /**
    *  单据状态
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;
    /**
    *  调出逻辑仓编码
    */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "调出逻辑仓编码")
    private String outLogicWarehouseCode;
    /**
    *  调出逻辑仓名称
    */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "调出逻辑仓名称")
    private String outLogicWarehouseName;
    /**
    *  调入逻辑仓编码
    */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "调入逻辑仓编码")
    private String inLogicWarehouseCode;
    /**
    *  调入逻辑仓名称
    */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入逻辑仓名称")
    private String inLogicWarehouseName;
    /**
    *  调出物理仓编码
    */
    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "调出物理仓编码")
    private String outPhysicsWarehouseCode;
    /**
    *  调出物理仓名称
    */
    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "调出物理仓名称")
    private String outPhysicsWarehouseName;
    /**
    *  调入物理仓编码
    */
    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "调入物理仓编码")
    private String inPhysicsWarehouseCode;
    /**
    *  调入物理仓名称
    */
    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "调入物理仓名称")
    private String inPhysicsWarehouseName;
    /**
    *  调出库存组织
    */
    @ApiModelProperty(name = "outOrganization", value = "调出库存组织")
    private String outOrganization;
    /**
    *  调出库存组织id
    */
    @ApiModelProperty(name = "outOrganizationId", value = "调出库存组织id")
    private Long outOrganizationId;
    /**
    *  调入库存组织
    */
    @ApiModelProperty(name = "inOrganization", value = "调入库存组织")
    private String inOrganization;
    /**
    *  调入库存组织id
    */
    @ApiModelProperty(name = "inOrganizationId", value = "调入库存组织id")
    private Long inOrganizationId;
    /**
    *  总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
    *  物流商编码
    */
    @ApiModelProperty(name = "shipmentEnterpriseCode", value = "物流商编码")
    private String shipmentEnterpriseCode;
    /**
    *  联系人
    */
    @ApiModelProperty(name = "contact", value = "联系人")
    private String contact;
    /**
    *  联系方式
    */
    @ApiModelProperty(name = "contactPhone", value = "联系方式")
    private String contactPhone;
    /**
    *  省
    */
    @ApiModelProperty(name = "province", value = "省")
    private String province;
    /**
    *  省编码
    */
    @ApiModelProperty(name = "provinceCode", value = "省编码")
    private String provinceCode;
    /**
    *  市
    */
    @ApiModelProperty(name = "city", value = "市")
    private String city;
    /**
    *  市编码
    */
    @ApiModelProperty(name = "cityCode", value = "市编码")
    private String cityCode;
    /**
    *  区
    */
    @ApiModelProperty(name = "area", value = "区")
    private String area;
    /**
    *  区编码
    */
    @ApiModelProperty(name = "areaCode", value = "区编码")
    private String areaCode;
    /**
    *  街道
    */
    @ApiModelProperty(name = "street", value = "街道")
    private String street;
    /**
    *  详细地址
    */
    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  来源系统
    */
    @ApiModelProperty(name = "sourceSystem", value = "来源系统")
    private String sourceSystem;
    /**
    *  调拨单子类型：allot_out 普通调拨，allot_out_only 调拨出库，allot_in_only 调拨入库，allot_only_record 仅记录 
    */
    @ApiModelProperty(name = "subType", value = "调拨单子类型：allot_out 普通调拨，allot_out_only 调拨出库，allot_in_only 调拨入库，allot_only_record 仅记录 ")
    private String subType;
    /**
    *  计划调出时间
    */
    @ApiModelProperty(name = "planOutTime", value = "计划调出时间")
    private Date planOutTime;
    /**
    *  计划调入时间
    */
    @ApiModelProperty(name = "planInTime", value = "计划调入时间")
    private Date planInTime;

    /**
     *  调拨明细
     */
    @ApiModelProperty(name = "transferOrderDetailList", value = "调拨明细")
    private List<TransferOrderDetailRespDto> transferOrderDetailList;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setTransferOrderNo(String transferOrderNo){
    this.transferOrderNo = transferOrderNo;
    }
    public String getTransferOrderNo(){
    return this.transferOrderNo;
    }
    public void setPreOrderNo(String preOrderNo){
    this.preOrderNo = preOrderNo;
    }
    public String getPreOrderNo(){
    return this.preOrderNo;
    }
    public void setExternalPurchaseOrderNo(String externalPurchaseOrderNo){
    this.externalPurchaseOrderNo = externalPurchaseOrderNo;
    }
    public String getExternalPurchaseOrderNo(){
    return this.externalPurchaseOrderNo;
    }
    public void setExternalSaleOrderNo(String externalSaleOrderNo){
    this.externalSaleOrderNo = externalSaleOrderNo;
    }
    public String getExternalSaleOrderNo(){
    return this.externalSaleOrderNo;
    }
    public void setType(String type){
    this.type = type;
    }
    public String getType(){
    return this.type;
    }
    public void setOrderSrc(String orderSrc){
    this.orderSrc = orderSrc;
    }
    public String getOrderSrc(){
    return this.orderSrc;
    }
    public void setOrderStatus(String orderStatus){
    this.orderStatus = orderStatus;
    }
    public String getOrderStatus(){
    return this.orderStatus;
    }
    public void setOutLogicWarehouseCode(String outLogicWarehouseCode){
    this.outLogicWarehouseCode = outLogicWarehouseCode;
    }
    public String getOutLogicWarehouseCode(){
    return this.outLogicWarehouseCode;
    }
    public void setOutLogicWarehouseName(String outLogicWarehouseName){
    this.outLogicWarehouseName = outLogicWarehouseName;
    }
    public String getOutLogicWarehouseName(){
    return this.outLogicWarehouseName;
    }
    public void setInLogicWarehouseCode(String inLogicWarehouseCode){
    this.inLogicWarehouseCode = inLogicWarehouseCode;
    }
    public String getInLogicWarehouseCode(){
    return this.inLogicWarehouseCode;
    }
    public void setInLogicWarehouseName(String inLogicWarehouseName){
    this.inLogicWarehouseName = inLogicWarehouseName;
    }
    public String getInLogicWarehouseName(){
    return this.inLogicWarehouseName;
    }
    public void setOutPhysicsWarehouseCode(String outPhysicsWarehouseCode){
    this.outPhysicsWarehouseCode = outPhysicsWarehouseCode;
    }
    public String getOutPhysicsWarehouseCode(){
    return this.outPhysicsWarehouseCode;
    }
    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName){
    this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }
    public String getOutPhysicsWarehouseName(){
    return this.outPhysicsWarehouseName;
    }
    public void setInPhysicsWarehouseCode(String inPhysicsWarehouseCode){
    this.inPhysicsWarehouseCode = inPhysicsWarehouseCode;
    }
    public String getInPhysicsWarehouseCode(){
    return this.inPhysicsWarehouseCode;
    }
    public void setInPhysicsWarehouseName(String inPhysicsWarehouseName){
    this.inPhysicsWarehouseName = inPhysicsWarehouseName;
    }
    public String getInPhysicsWarehouseName(){
    return this.inPhysicsWarehouseName;
    }
    public void setOutOrganization(String outOrganization){
    this.outOrganization = outOrganization;
    }
    public String getOutOrganization(){
    return this.outOrganization;
    }
    public void setOutOrganizationId(Long outOrganizationId){
    this.outOrganizationId = outOrganizationId;
    }
    public Long getOutOrganizationId(){
    return this.outOrganizationId;
    }
    public void setInOrganization(String inOrganization){
    this.inOrganization = inOrganization;
    }
    public String getInOrganization(){
    return this.inOrganization;
    }
    public void setInOrganizationId(Long inOrganizationId){
    this.inOrganizationId = inOrganizationId;
    }
    public Long getInOrganizationId(){
    return this.inOrganizationId;
    }
    public void setTotalQuantity(BigDecimal totalQuantity){
    this.totalQuantity = totalQuantity;
    }
    public BigDecimal getTotalQuantity(){
    return this.totalQuantity;
    }
    public void setShipmentEnterpriseCode(String shipmentEnterpriseCode){
    this.shipmentEnterpriseCode = shipmentEnterpriseCode;
    }
    public String getShipmentEnterpriseCode(){
    return this.shipmentEnterpriseCode;
    }
    public void setContact(String contact){
    this.contact = contact;
    }
    public String getContact(){
    return this.contact;
    }
    public void setContactPhone(String contactPhone){
    this.contactPhone = contactPhone;
    }
    public String getContactPhone(){
    return this.contactPhone;
    }
    public void setProvince(String province){
    this.province = province;
    }
    public String getProvince(){
    return this.province;
    }
    public void setProvinceCode(String provinceCode){
    this.provinceCode = provinceCode;
    }
    public String getProvinceCode(){
    return this.provinceCode;
    }
    public void setCity(String city){
    this.city = city;
    }
    public String getCity(){
    return this.city;
    }
    public void setCityCode(String cityCode){
    this.cityCode = cityCode;
    }
    public String getCityCode(){
    return this.cityCode;
    }
    public void setArea(String area){
    this.area = area;
    }
    public String getArea(){
    return this.area;
    }
    public void setAreaCode(String areaCode){
    this.areaCode = areaCode;
    }
    public String getAreaCode(){
    return this.areaCode;
    }
    public void setStreet(String street){
    this.street = street;
    }
    public String getStreet(){
    return this.street;
    }
    public void setAddress(String address){
    this.address = address;
    }
    public String getAddress(){
    return this.address;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setCustomerCode(String customerCode){
    this.customerCode = customerCode;
    }
    public String getCustomerCode(){
    return this.customerCode;
    }
    public void setCustomerName(String customerName){
    this.customerName = customerName;
    }
    public String getCustomerName(){
    return this.customerName;
    }
    public void setSourceSystem(String sourceSystem){
    this.sourceSystem = sourceSystem;
    }
    public String getSourceSystem(){
    return this.sourceSystem;
    }
    public void setSubType(String subType){
    this.subType = subType;
    }
    public String getSubType(){
    return this.subType;
    }
    public void setPlanOutTime(Date planOutTime){
    this.planOutTime = planOutTime;
    }
    public Date getPlanOutTime(){
    return this.planOutTime;
    }
    public void setPlanInTime(Date planInTime){
    this.planInTime = planInTime;
    }
    public Date getPlanInTime(){
    return this.planInTime;
    }

    public List<TransferOrderDetailRespDto> getTransferOrderDetailList() {
        return transferOrderDetailList;
    }

    public void setTransferOrderDetailList(List<TransferOrderDetailRespDto> transferOrderDetailList) {
        this.transferOrderDetailList = transferOrderDetailList;
    }
}
