package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 信用流水明细
 * @since 2022-01-19 17:42
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditRecordDetailRespDto", description = "信用流水明细")
public class CreditRecordDetailRespDto extends ReportBaseRespDto{

    @ApiModelProperty(name = "creditEntityCode", value = "授信主体编号")
    private String creditEntityCode;

    @ApiModelProperty(name = "creditRecordCode", value = "信用流水编号")
    private String creditRecordCode;

    @ApiModelProperty(name = "creditAccountCode", value = "信用账户")
    private String creditAccountCode;

    @ApiModelProperty(name = "changeRemark", value = "变动原因")
    private String changeRemark;

    @ApiModelProperty(name = "orderNo", value = "关联单号")
    private String orderNo;

    @ApiModelProperty(name = "changeQuota", value = "变动额度")
    private BigDecimal changeQuota;

    @ApiModelProperty(name = "remainingQuota", value = "变动后可用额度")
    private BigDecimal remainingQuota;

    @ApiModelProperty(name = "changeTime", value = "变动时间")
    private String changeTime;
}
