package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsOutNoticeOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.InTransitInNoticeDetailReqDto;
import com.dtyunxi.tcbj.api.vo.InTransitInNoticeDetailVo;
import com.dtyunxi.tcbj.api.dto.response.CsOutNoticeOrderDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 出/入库通知单明细服务接口
 *
 * @author 天泽
 * @since 2022-08-30
 */
@Api(tags = {"出/入库通知单明细服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-ICsOutNoticeOrderDetailQueryApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/csOutNoticeOrderDetail",
        url = "${tcbj.center.report.api:}"
)
public interface ICsOutNoticeOrderDetailQueryApi {

    /**
     * 根据id查询出/入库通知单明细
     *
     * @param id 出/入库通知单明细id
     * @return   出/入库通知单明细数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出/入库通知单明细", notes = "根据id查询出/入库通知单明细")
    RestResponse<CsOutNoticeOrderDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 出/入库通知单明细分页数据
     *
     * @param filter   出/入库通知单明细查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 出/入库通知单明细分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "出/入库通知单明细分页数据", notes = "根据filter查询条件查询出/入库通知单明细数据，filter=CsOutNoticeOrderDetailReqDto")
    RestResponse<PageInfo<CsOutNoticeOrderDetailRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 出/入库通知单明细分页数据
     *
     * @param orderNos   出/入库通知单号
     */
    @PostMapping("/list")
    @ApiOperation(value = "出/入库通知单明细数据", notes = "出/入库通知单明细数据")
    RestResponse<List<CsOutNoticeOrderDetailRespDto>> queryByNos(@RequestBody List<String> orderNos);

    /**
     * 出/入库通知单明细分页数据
     *
     * @param reqDto   出/入库通知单号
     * @return
     */
    @PostMapping("/post/list")
    @ApiOperation(value = "出/入库通知单明细数据", notes = "出/入库通知单明细数据")
    RestResponse<PageInfo<CsOutNoticeOrderDetailRespDto>> queryByPagePost(@RequestBody CsOutNoticeOrderDetailReqDto reqDto);

    /**
     * 在途仓交易明细
     * @param reqDto
     * @return
     */
    @PostMapping("/inTransitInNoticeDetail")
    @ApiOperation(value = "在途仓里指定sku的入库通知单明细数量",notes = "根据在途仓编码和sku,查询入库通知单的明细数量")
    RestResponse<PageInfo<InTransitInNoticeDetailVo>> inTransitInNoticeDetail(@RequestBody InTransitInNoticeDetailReqDto reqDto);

    @PostMapping("/querySaleByPagePost")
    @ApiOperation(value = "销售单出库通知明细数据",notes = "销售单出库通知明细数据")
    RestResponse<List<CsOutNoticeOrderDetailRespDto>> querySaleByPagePost(@RequestBody CsOutNoticeOrderDetailReqDto reqDto);


}
