package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 组合套装活动商品返回Dto
 *
 * @author haoyang
 * @date 2021/11/23 9:44
 * @since 0.1.0
 */
public class CombinedPackageActivityItemRespDto {
    /**
     * id
     */
    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    /**
     * 商品类型（ITEM：商品、GIFT：赠品）
     */
    @ApiModelProperty(name = "itemType", value = "商品类型（ITEM：商品、GIFT：赠品）")
    private String itemType;
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * sku_id
     */
    @ApiModelProperty(name = "skuId", value = "sku_id")
    private Long skuId;

    /**
     * sku_code
     */
    @ApiModelProperty(name = "skuCode", value = "sku_code")
    private String skuCode;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     * 商品规格
     */
    @ApiModelProperty(name = "attrs", value = "规格属性")
    private String attrs;

    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     * 商品子类型
     */
    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    /**
     * 图片
     */
    @ApiModelProperty(name = "picture", value = "图片")
    private String picture;

    /**
     * 商品分类编码
     */
    @ApiModelProperty(name = "categoryCode", value = "商品分类编码")
    private String categoryCode;

    /**
     * 活动库存
     */
    @ApiModelProperty(name = "originalStock", value = "活动库存")
    private Long originalStock;
    /**
     * 剩余库存
     */
    @ApiModelProperty(name = "remainingStock", value = "剩余库存")
    private Long remainingStock;

    /**
     * 活动ID
     */
    @ApiModelProperty(name = "activityId", value = "活动ID")
    private Long activityId;


    /**
     * 商品原价（单位：元）
     */
    @ApiModelProperty(name = "price", value = "商品原价")
    private BigDecimal price;

    /**
     * 数量
     */
    @ApiModelProperty(name = "num", value = "数量")
    private Integer num;

    /**
     * 活动价格（单位：元）
     */
    @ApiModelProperty(name = "activityPrice", value = "活动价格")
    private BigDecimal activityPrice;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    /**
     * 商品上架价格
     */
    @ApiModelProperty(name = "shelfPrice", value = "商品上架价格")
    private BigDecimal shelfPrice;

    /**
     * 单位名称
     */
    @ApiModelProperty(name = "unit", value = "单位ID")
    private String unit;

    /**
     * 单位名称
     */
    @ApiModelProperty(name = "unitName", value = "单位名称")
    private String unitName;

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getPicture() {
        return picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }
    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public Long getOriginalStock() {
        return originalStock;
    }

    public void setOriginalStock(Long originalStock) {
        this.originalStock = originalStock;
    }

    public Long getRemainingStock() {
        return remainingStock;
    }

    public void setRemainingStock(Long remainingStock) {
        this.remainingStock = remainingStock;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public BigDecimal getActivityPrice() {
        return activityPrice;
    }

    public void setActivityPrice(BigDecimal activityPrice) {
        this.activityPrice = activityPrice;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public BigDecimal getShelfPrice() {
        return shelfPrice;
    }

    public void setShelfPrice(BigDecimal shelfPrice) {
        this.shelfPrice = shelfPrice;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
}
