package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CsCustomerRespDto;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = {"客户中心:PCP客户信息接口服务"})
@FeignClient(name = "${tcbj.center.report.api.name:tcbj-center-report}",
        url = "${tcbj.center.report.api:}",
        path = "/v2/pcp-customer"
)
public interface IPCPCustomerQueryApi {

    @GetMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "客户列表分页查询", notes = "客户列表分页查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "filter", value = "过滤条件\t\n " +
                    "filter:封装对象JSON {\n" +
                    "    \"keyword\": 关键字:名称/编号\n" +
                    "    \"userName\": 登录账号,\n" +
                    "    \"regionIds\":所属区域集合,\n" +
                    "    \"regionCodes\":所属区域编码集合,\n" +
                    "    \"customerTypeIds\":客户类型集合,\n" +
                    "    \"statusId\":客户状态,\n" +
                    "    \"userIds\":管理员ID集合(登录账号集合),\n" +
                    "    \"idList\":id列表,\n" +
                    "    \"userFlag\":账号标识（true:查到符合条件的账号，false:未查到符合条件的账号）,\n" +
                    "    \"srcType\":来源类型（1:经销商小程序端，2:PC管理端，3:业务员小程序端）,\n" +
                    "    \"salesmanId\": 业务员ID,\n" +
                    "    \"customerGroupIds\": 客户分组id集合,\n" +
                    "    \"levelId\": 客户级别id,\n" +
                    "    \"companyName\": 客户名称,\n" +
                    "    \"listFlag\": 查询标识（true:列表查询，false:审核列表）,默认false查询审核列表,\n" +
                    "    \"type\": 客户类型（1：品牌商，2：大B，3：零售商）,\n" +
                    "    \"auditStatus\": 审核状态（WAIT_AUDIT：待审核、AUDIT_REJECT：审核不通过、AUDIT_PASS：审核通过、INVALID：作废、DRAFT：草稿）,\n" +
                    "    \"merchantId\": 所属商家,\n" +
                    "    \"settleStatus\": 入驻状态（1：未入驻、2：申请中、3：已入驻(启用)、4：禁用）,\n" +
                    "    \"settleStatusList\": 入驻状态集合,\n" +
                    "    \"channel\": 渠道类型（1：品牌方运营端，2：大B卖家端）,\n" +
                    "    \"ifCertification\": 是否认证统一社会信用代码  0否，1是,\n" +
                    "    \"instanceId\": 0,\n" +
                    "    \"tenantId\": 0\n" +
                    "}", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "int", paramType = "query", required = true)})
    RestResponse<PageInfo<CsCustomerRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                          @RequestParam("pageNum") Integer pageNum,
                                                          @RequestParam("pageSize") Integer pageSize);

    @GetMapping(value = "/id/{id}")
    @ApiOperation(value = "查询客户信息详情", notes = "查询客户信息详情")
    @ApiImplicitParam(name = "id", value = "ID", dataType = "Long", paramType = "path", required = true)
    RestResponse<PCPCustomerRespDto> queryPCPCustomerDetailById(@PathVariable("id") Long id);

    @GetMapping(value = "/code/{code}")
    @ApiOperation(value = "查询客户信息详情", notes = "查询客户信息详情")
    @ApiImplicitParam(name = "code", value = "CODE", dataType = "Long", paramType = "path", required = true)
    RestResponse<PCPCustomerRespDto> queryPCPCustomerDetailByCode(@PathVariable("code") String code);

    @PostMapping(value = "/queryPCPCustomerDetail", produces = "application/json")
    @ApiOperation(value = "客户详情查询", notes = "客户详情查询")
    RestResponse<List<PCPCustomerRespDto>> queryPCPCustomerDetail(@RequestBody PCPCustomerSearchReqDto searchReqDto);

    @PostMapping(value = "/queryPCPCustomerDetailByPage", produces = "application/json")
    @ApiOperation(value = "客户列表分页查询", notes = "客户列表分页查询")
    RestResponse<PageInfo<PCPCustomerRespDto>> queryPCPCustomerDetailByPage(@RequestBody PCPCustomerSearchReqDto searchReqDto);

    @PostMapping(value = "/queryPCPCustomerDetailByCodes", produces = "application/json")
    @ApiOperation(value = "根据客户编码列表查询客户信息", notes = "根据客户编码列表查询客户信息")
    RestResponse<List<PCPCustomerRespDto>> queryPCPCustomerDetailByCodes(@RequestBody List<String> codes);
}