package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @author xiuji
 * @Description 员工信息返回Dto
 */
@ApiModel(value = "EmployeeOrgRespDto", description = "组织人员信息")
public class EmployeeOrgRespDto extends BaseRespDto {

    /**
     * 姓名
     */
    @Size(message = "姓名字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(name = "name", value = "姓名")
    private String name;

    /**
     * 登录账号
     */
    @ApiModelProperty(name = "userName", value = "登录账号")
    private String userName;

    /**
     * 职位
     */
    @ApiModelProperty(name = "position", value = "职位")
    private String position;

    /**
     * 性别：0-保密，1-女，2-男
     */
    @ApiModelProperty(name = "sex", value = "性别：1-女，2-男")
    private String sex;

    /**
     * 开始日期
     */
    @ApiModelProperty(name = "startTime", value = "开始日期")
    private Date startTime;

    /**
     * 结束日期
     */
    @ApiModelProperty(name = "endTime", value = "结束日期")
    private Date endTime;

    /**
     * 身份证号码
     */
    @ApiModelProperty(name = "idCardNo", value = "身份证号码")
    private String idCardNo;

    /**
     * 生日
     */
    @ApiModelProperty(name = "birthday", value = "生日")
    private Date birthday;

    /**
     * 家庭电话
     */
    @ApiModelProperty(name = "homeTel", value = "家庭电话")
    private String homeTel;

    /**
     * 固定电话
     */
    @ApiModelProperty(name = "fixedTel", value = "固定电话")
    private String fixedTel;

    /**
     * 分机号
     */
    @ApiModelProperty(name = "extTelNumber", value = "分机号")
    private String extTelNumber;

    /**
     * qq
     */
    @ApiModelProperty(name = "qq", value = "qq")
    private String qq;

    /**
     * 微信
     */
    @ApiModelProperty(name = "wechat", value = "微信")
    private String wechat;

    /**
     * 传真
     */
    @ApiModelProperty(name = "fax", value = "传真")
    private String fax;

    /**
     * 学历
     */
    @ApiModelProperty(name = "education", value = "学历")
    private String education;

    /**
     * 联系地址
     */
    @ApiModelProperty(name = "contactAddress", value = "联系地址")
    private String contactAddress;

    /**
     * 入职时间
     */
    @ApiModelProperty(name = "entryTime", value = "入职时间")
    private Date entryTime;

    /**
     * 离职时间
     */
    @ApiModelProperty(name = "departureTime", value = "离职时间")
    private Date departureTime;

    /**
     * 工号
     */
    @Size(message = "工号字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(name = "employeeNo", value = "工号, 选填")
    private String employeeNo;

    /**
     * 手机号码
     */
    @Size(message = "手机号码字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(name = "phoneNum", value = "手机号码, 选填")
    private String phoneNum;

    /**
     * 员工编号
     */
    @Size(message = "员工编号字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(name = "email", value = "邮箱号, 选填")
    private String email;

    /**
     * 员工状态
     */
    @ApiModelProperty(name = "status", value = "员工状态: 1启用,2禁用.默认启用", allowableValues = "0,1,2")
    private Integer status;

    /**
     * 部门
     */
    @ApiModelProperty(name = "station", value = "部门")
    private String station;

    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "用户Id, 选填")
    private Long userId;

    /**
     * 员工昵称
     */
    @Size(message = "员工昵称字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(name = "nickName", value = "昵称, 选填")
    private String nickName;

    /**
     * 备注
     */
    @Size(message = "备注字符长度为[1-255]", max = 255)
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;


    /**
     * 所选组织ID
     */
    @ApiModelProperty(name = "orgId", value = "所选组织ID")
    private Long orgId;

    /**
     * 组织代码
     */
    @ApiModelProperty(name = "organizationCode",value = "组织代码")
    private String organizationCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName",value = "组织名称")
    private String organizationName;

    /**
     * 是否组织人员状态，0否，1是
     */
    @ApiModelProperty(name = "organizationStatus",value = "是否组织人员状态，0否，1是")
    private Integer organizationStatus;

    /**
     * 商家id
     */
    @ApiModelProperty(name = "sellerId",value = "商家id")
    private Long sellerId;
    /**
     * 商家名称
     */
    @ApiModelProperty(name = "sellerName",value = "商家名称")
    private String sellerName;

    /**
     * 上级商家名称
     */
    @ApiModelProperty(name = "superiorSellerName",value = "上级商家名称")
    private String superiorSellerName;

    /**
     * 客户/经销商编号
     */
    @ApiModelProperty(name = "dealerCode",value = "客户/经销商编号")
    private String dealerCode;

    /**
     * 人员ID
     */
    @ApiModelProperty(name = "staffId", value = "人员ID")
    private String staffId;

    /**
     * 角色
     */
    @ApiModelProperty(name = "roleNames", value = "角色")
    private String roleNames;


    /**
     * 管理区域数
     */
    @ApiModelProperty(name = "customerAreaNum", value = "管理区域数")
    private int customerAreaNum;


    /**
     * 管理客户数
     */
    @ApiModelProperty(name = "customerNum", value = "管理客户数")
    private int customerNum;

    @ApiModelProperty(name = "orgName", value = "组织名称")
    private String orgName;

    @ApiModelProperty(name = "orgCode", value = "组织编码")
    private String orgCode;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getHomeTel() {
        return homeTel;
    }

    public void setHomeTel(String homeTel) {
        this.homeTel = homeTel;
    }

    public String getFixedTel() {
        return fixedTel;
    }

    public void setFixedTel(String fixedTel) {
        this.fixedTel = fixedTel;
    }

    public String getExtTelNumber() {
        return extTelNumber;
    }

    public void setExtTelNumber(String extTelNumber) {
        this.extTelNumber = extTelNumber;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getWechat() {
        return wechat;
    }

    public void setWechat(String wechat) {
        this.wechat = wechat;
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEducation() {
        return education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public String getContactAddress() {
        return contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public Date getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }

    public Date getDepartureTime() {
        return departureTime;
    }

    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getStaffId() {
        return staffId;
    }

    public void setStaffId(String staffId) {
        this.staffId = staffId;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getOrganizationStatus() {
        return organizationStatus;
    }

    public void setOrganizationStatus(Integer organizationStatus) {
        this.organizationStatus = organizationStatus;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSuperiorSellerName() {
        return superiorSellerName;
    }

    public void setSuperiorSellerName(String superiorSellerName) {
        this.superiorSellerName = superiorSellerName;
    }

    public String getDealerCode() {
        return dealerCode;
    }

    public void setDealerCode(String dealerCode) {
        this.dealerCode = dealerCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getStation() {
        return station;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public String getRoleNames() {
        return roleNames;
    }

    public void setRoleNames(String roleNames) {
        this.roleNames = roleNames;
    }

    public int getCustomerAreaNum() {
        return customerAreaNum;
    }

    public void setCustomerAreaNum(int customerAreaNum) {
        this.customerAreaNum = customerAreaNum;
    }

    public int getCustomerNum() {
        return customerNum;
    }

    public void setCustomerNum(int customerNum) {
        this.customerNum = customerNum;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
