package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReceivablesImportReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReceivablesReqDto;
import com.dtyunxi.tcbj.api.dto.response.BalanceOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesImportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author bixuan
 * @since 1.0.0
 */
@Api(tags = {"报表中心：应收账款"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/receivables",
        url = "${tcbj.center.report.api:}"
)
public interface IReceivablesApi {

    /**
     * 定时任务生成应收账款
     *
     */
    @PostMapping(value = {"/saveReceivablesJob"}, produces = "application/json")
    @ApiOperation(value = "定时任务生成应收账款", notes = "定时任务生成应收账款")
    RestResponse<Void> saveReceivablesJob(@RequestBody List<Long> customerIdList);

    @PostMapping(value = {"/receivablesImport"}, produces = "application/json")
    @ApiOperation(value = "应收账款导入", notes = "应收账款导入")
    RestResponse<ReceivablesImportRespDto> receivablesImport(@RequestBody ReceivablesImportReqDto reqDto);

}
