package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
* 仓储账单明细表Eo对象
*
* @author by_liusong
* @since 2022-07-15
*/
@ApiModel(value = "StorageChargeDetailReqDto", description = "仓储账单明细表Eo对象")
@Data
public class StorageChargeDetailReqDto extends RequestDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  统计日期
    */
    @ApiModelProperty(name = "storageTime", value = "统计日期")
    private Date storageTime;
    /**
     *  统计日期
     */
    @ApiModelProperty(name = "storageStartTime", value = "统计开始日期")
    private Date storageStartTime;

    /**
     *  统计日期
     */
    @ApiModelProperty(name = "storageEndTime", value = "统计结束日期")
    private Date storageEndTime;
    /**
     *  记账月份
     */
    @ApiModelProperty(name = "billTime", value = "记账月份")
    private String billTime;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  商品长码
    */
    @ApiModelProperty(name = "opLongCode", value = "商品长码")
    private String opLongCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  逻辑仓编码
    */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;
    /**
    *  逻辑仓名称
    */
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓名称")
    private String logicWarehouseName;
    /**
    *  计费组织id
    */
    @ApiModelProperty(name = "chargeOrgId", value = "库存组织id")
    private Long chargeOrgId;
    /**
    *  计费组织名称
    */
    @ApiModelProperty(name = "chargeOrgName", value = "库存组织名称")
    private String chargeOrgName;

    /**
     *  库存组织id
     */
    @ApiModelProperty(name = "belongOrgId", value = "库存组织id")
    private Long belongOrgId;
    /**
     *  库存组织名称
     */
    @ApiModelProperty(name = "belongOrgName", value = "库存组织名称")
    private String belongOrgName;
    /**
    *  期初库存
    */
    @ApiModelProperty(name = "initialInventoryNum", value = "期初库存")
    private Integer initialInventoryNum;
    /**
    *  入库数量
    */
    @ApiModelProperty(name = "inDeliveryNum", value = "入库数量")
    private Integer inDeliveryNum;
    /**
    *  出库数量
    */
    @ApiModelProperty(name = "outDeliveryNum", value = "出库数量")
    private Integer outDeliveryNum;
    /**
    *  期末库存
    */
    @ApiModelProperty(name = "endInventoryNum", value = "期末库存")
    private Integer endInventoryNum;
    /**
    *  调整类型；0：减少 1：增加
    */
    @ApiModelProperty(name = "adjustType", value = "调整类型；0：减少 1：增加")
    private Integer adjustType;
    /**
    *  调整库存数
    */
    @ApiModelProperty(name = "adjustDeliveryNum", value = "调整库存数")
    private Integer adjustDeliveryNum;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     *  码托数
     */
    @ApiModelProperty(name = "zhTrayNum", value = "码托数")
    private Integer zhTrayNum;
    /**
    *  装箱数
    */
    @ApiModelProperty(name = "packingQuantity", value = "装箱数")
    private Integer packingQuantity;
    /**
    *  出库总体积
    */
    @ApiModelProperty(name = "allOutVolume", value = "出库总体积")
    private BigDecimal allOutVolume;
    /**
    *  当日总板数
    */
    @ApiModelProperty(name = "allDaySupport", value = "当日总板数")
    private Integer allDaySupport;
    /**
    *  组织所占板数
    */
    @ApiModelProperty(name = "organizationSupport", value = "组织所占板数")
    private BigDecimal organizationSupport;
    /**
    *  业务类型;0:常规计费;1:内部交易;2:人工分摊;
    */
    @ApiModelProperty(name = "bizType", value = "业务类型;0:常规计费;1:内部交易;2:人工分摊;")
    private Integer bizType;

    /**
     *  账单异常信息
     */
    @ApiModelProperty(name = "exceptionInfo", value = "账单异常信息")
    private String exceptionInfo;

    /**
     *  是否异常
     */
    @ApiModelProperty(name = "isException", value = "是否异常")
    private Integer isException;

    /**
    *  组织id
    */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    private Integer pageSize;
    private Integer pageNum;

    private List<String> warehouseCodeList;


}
