package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.IntransitCargoQueryDto;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.RecentDeliveredReqDto;
import com.dtyunxi.tcbj.api.dto.response.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 出库结果单服务接口
*
* @author wude
* @since 2022-03-10
*/
@Api(tags = {"出库结果单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/outResultOrder", url = "${tcbj.center.report.api:}")
public interface IOutResultOrderQueryApi {

    /**
    * 根据id查询出库结果单
    *
    * @param id 出库结果单id
    * @return   出库结果单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出库结果单", notes = "根据id查询出库结果单")
    RestResponse<OutResultOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据consignNo查询出库结果单
     *
     * @param consignNo 出库结果单id
     * @return   出库结果单数据
     */
    @GetMapping("/queryByConsignNo/{consignNo}/cspNo/{cspNo}")
    @ApiOperation(value = "根据托运查询出库结果单", notes = "根据id查询出库结果单")
    RestResponse<OutResultOrderRespDto> queryByConsignNo(@PathVariable("consignNo") String consignNo,@PathVariable("cspNo") String cspNo);

    @GetMapping("/queryByConsignNos/{consignNo}/cspNo/{cspNo}")
    @ApiOperation(value = "根据托运查询出库结果单", notes = "根据id查询出库结果单")
    RestResponse<List<CsOutResultOrderDetailRespDto>> queryCsOutResultByConsignNos(@PathVariable("consignNo") String consignNo, @PathVariable("cspNo") String cspNo);

    /**
    * 出库结果单分页数据
    *
    * @param filter   出库结果单查询条件
    * @return 出库结果单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "出库结果单分页数据", notes = "根据filter查询条件查询出库结果单数据，filter=OutResultOrderReqDto")
    RestResponse<PageInfo<OutResultOrderRespDto>> queryByPage(@RequestBody OutResultOrderReqDto filter);

    @PostMapping("/queryByPageInResult")
    @ApiOperation(value = "入库结果单分页数据", notes = "根据filter查询条件查询入库结果单数据，filter=OutResultOrderReqDto")
    RestResponse<PageInfo<OutResultOrderRespDto>> queryByPageInResult(@RequestBody OutResultOrderReqDto filter);

    @PostMapping("/detailPage")
    @ApiOperation(value = "出库结果单分页数据", notes = "根据filter查询条件查询出库结果单数据，filter=OutResultOrderReqDto")
    RestResponse<PageInfo<CsOutResultOrderDetailRespDto>> queryDetailByPage(@RequestBody OutResultOrderReqDto filter);

    /**
     * 根据销售单查询最近一次已发货的批次
     *
     *
     * @return 出库结果单分页数据
     */
    @PostMapping("/recentDelivered")
    @ApiOperation(value = "根据销售单查询最近一次已发货的批次", notes = "根据销售单查询最近一次已发货的批次,filter=relevanceNos")
    RestResponse<PageInfo<RecentDeliveredRespDto>> queryRecentDelivered(@RequestBody RecentDeliveredReqDto reqDto);

    @PostMapping("/queryDeliveryInformation/{bussinessOrderNo}")
    @ApiOperation(value = "根据其他出入库单号查询配送信息", notes = "根据其他出入库单号查询配送信息")
    RestResponse<List<DeliveryInformationRespDto>> queryDeliveryInformation(@PathVariable("bussinessOrderNo") String bussinessOrderNo);

    /**
     * 异常监控分页
     *
     * @param outResultOrderReqDto   异常监控分页查询条件
     * @return 异常监控分页分页数据
     */
    @PostMapping("/queryAnomalyPage")
    @ApiOperation(value = "异常监控分页数据", notes = "异常监控分页数据")
    RestResponse<PageInfo<OutResultOrderRespDto>> queryAnomalyPage(@RequestBody OutResultOrderReqDto outResultOrderReqDto);

    @PostMapping("/queryIntransitCargoNum")
    @ApiOperation(value = "查询在途货品数量", notes = "查询在途货品数量")
    RestResponse<List<IntransitCargoRespDto>> queryIntransitCargoNum(@RequestBody IntransitCargoQueryDto queryDto);

    @PostMapping(value = "/queryDetailByRelevanceNo/{relevanceNo}", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<List<CsOutResultOrderDetailRespDto>> queryDetailByRelevanceNo(@PathVariable("relevanceNo") String relevanceNo);

    @PostMapping(value = "/query/sfHgResultOrder", produces = "application/json")
    @ApiOperation(value = "查询顺丰海柜结果单信息", notes = "查询顺丰海柜结果单信息")
    RestResponse<List<String>> querySfHgResultOrder();


}
