package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
* 仓储账单表Eo对象
*
* @author by_liusong
* @since 2022-07-15
*/
@ApiModel(value = "StorageChargeBillReqDto", description = "仓储账单表Eo对象")
@Data
public class StorageChargeBillReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  账单月份
    */
    @ApiModelProperty(name = "billTime", value = "账单月份")
    private String billTime;
    /**
    *  关联合同id
    */
    @ApiModelProperty(name = "contractId", value = "关联合同id")
    private Long contractId;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;

    private List<String> warehouseCodeList;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  逻辑仓编码
    */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;
    /**
    *  逻辑仓名称
    */
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓名称")
    private String logicWarehouseName;
    /**
    *  计费库存组织ID
    */
    @ApiModelProperty(name = "chargeOrgId", value = "计费库存组织ID")
    private String chargeOrgId;
    /**
    *  计费库存组织名称
    */
    @ApiModelProperty(name = "chargeOrgName", value = "计费库存组织名称")
    private String chargeOrgName;
    /**
    *  月实际总板数
    */
    @ApiModelProperty(name = "allMonthSupport", value = "月实际总板数")
    private BigDecimal allMonthSupport;
    /**
    *  合同每月日均板数
    */
    @ApiModelProperty(name = "contractAverageSupport", value = "合同每月日均板数")
    private BigDecimal contractAverageSupport;
    /**
    *  当月天数
    */
    @ApiModelProperty(name = "daysNum", value = "当月天数")
    private Integer daysNum;
    /**
    *  是否满足合同约定;0:不满足;1:满足;
    */
    @ApiModelProperty(name = "isSatisfy", value = "是否满足合同约定;0:不满足;1:满足;")
    private Integer isSatisfy;
    /**
    *  单价
    */
    @ApiModelProperty(name = "unitPrice", value = "单价")
    private BigDecimal unitPrice;
    /**
    *  仓储费
    */
    @ApiModelProperty(name = "warehouseCost", value = "仓储费")
    private BigDecimal warehouseCost;
    /**
    *  出库体积
    */
    @ApiModelProperty(name = "outDeliveryVolume", value = "出库体积")
    private Integer outDeliveryVolume;
    /**
     * 出库板数
     */
    @ApiModelProperty(name = "outDeliverySupport", value = "出库板数")
    private Integer outDeliverySupport;


    /**
     *  出库体积/板数
     */
    @ApiModelProperty(name = "outDeliveryProperty", value = "出库体积/板数")
    private BigDecimal outDeliveryProperty;
    /**
     *  体积/板数占比
     */
    @ApiModelProperty(name = "outPercentageProperty", value = "体积/板数占比")
    private BigDecimal outPercentageProperty;
    /**
    *  其他费用
    */
    @ApiModelProperty(name = "otherCost", value = "其他费用")
    private BigDecimal otherCost;
    /**
    *  合计仓储费
    */
    @ApiModelProperty(name = "totalWarehouseCost", value = "合计仓储费")
    private BigDecimal totalWarehouseCost;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    /**
     *  账单异常信息
     */
    @ApiModelProperty(name = "exceptionInfo", value = "账单异常信息")
    private String exceptionInfo;

    /**
     *  是否异常
     */
    @ApiModelProperty(name = "isExcepion", value = "是否异常")
    private Integer isExcepion;
    @ApiModelProperty(name = "billType", value = "单据类型")
    private Integer billType;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "year", value = "年份")
    private String year;

    private Integer pageSize;
    private Integer pageNum;

}
