package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 运单Eo对象
*
* @author 紫霄
* @since 2023-05-09
*/
@ApiModel(value = "ConsignmentOrderReqDto", description = "运单Eo对象")
public class ConsignmentOrderReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  运单号
    */
    @ApiModelProperty(name = "consignmentNo", value = "运单号")
    private String consignmentNo;
    /**
    *  运单类型：1:原单 2:转运单
    */
    @ApiModelProperty(name = "consignmentType", value = "运单类型：1:原单 2:转运单")
    private Integer consignmentType;
    /**
    *  wms运单号
    */
    @ApiModelProperty(name = "wmsConsignmentNo", value = "wms运单号")
    private String wmsConsignmentNo;
    /**
    *  原运单号(只在运单类型为转运单才存在)
    */
    @ApiModelProperty(name = "originConsignmentNo", value = "原运单号(只在运单类型为转运单才存在)")
    private String originConsignmentNo;
    /**
    *  原wms运单号(只在运单类型为转运单才存在)
    */
    @ApiModelProperty(name = "originWmsConsignmentNo", value = "原wms运单号(只在运单类型为转运单才存在)")
    private String originWmsConsignmentNo;
    /**
    *  副托运单号(原wms运单号+原发货物理仓简码)
    */
    @ApiModelProperty(name = "secondaryConsignmentNo", value = "副托运单号(原wms运单号+原发货物理仓简码)")
    private String secondaryConsignmentNo;
    /**
    *  出库结果单单号
    */
    @ApiModelProperty(name = "outResultNo", value = "出库结果单单号")
    private String outResultNo;
    /**
    *  出库通知单单号
    */
    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;
    /**
    *  业务单号
    */
    @ApiModelProperty(name = "businessNo", value = "业务单号")
    private String businessNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  外部单号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  合单号
    */
    @ApiModelProperty(name = "mergeOrderNo", value = "合单号")
    private String mergeOrderNo;
    /**
    *  运单状态，0:待出库确认, 1:正常, 2:已转运
    */
    @ApiModelProperty(name = "orderStatus", value = "运单状态，0:待出库确认, 1:正常, 2:已转运")
    private Integer orderStatus;
    /**
    *  转运单单号
    */
    @ApiModelProperty(name = "transferConsignmentNo", value = "转运单单号")
    private String transferConsignmentNo;
    /**
    *  转运单wms单号
    */
    @ApiModelProperty(name = "transferWmsConsignmentNo", value = "转运单wms单号")
    private String transferWmsConsignmentNo;
    /**
    *  父运单单号
    */
    @ApiModelProperty(name = "parentConsignmentNo", value = "父运单单号")
    private String parentConsignmentNo;
    /**
    *  父运单wms单号
    */
    @ApiModelProperty(name = "parentWmsConsignmentNo", value = "父运单wms单号")
    private String parentWmsConsignmentNo;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setConsignmentNo(String consignmentNo){
    this.consignmentNo = consignmentNo;
    }
    public String getConsignmentNo(){
    return this.consignmentNo;
    }
    public void setConsignmentType(Integer consignmentType){
    this.consignmentType = consignmentType;
    }
    public Integer getConsignmentType(){
    return this.consignmentType;
    }
    public void setWmsConsignmentNo(String wmsConsignmentNo){
    this.wmsConsignmentNo = wmsConsignmentNo;
    }
    public String getWmsConsignmentNo(){
    return this.wmsConsignmentNo;
    }
    public void setOriginConsignmentNo(String originConsignmentNo){
    this.originConsignmentNo = originConsignmentNo;
    }
    public String getOriginConsignmentNo(){
    return this.originConsignmentNo;
    }
    public void setOriginWmsConsignmentNo(String originWmsConsignmentNo){
    this.originWmsConsignmentNo = originWmsConsignmentNo;
    }
    public String getOriginWmsConsignmentNo(){
    return this.originWmsConsignmentNo;
    }
    public void setSecondaryConsignmentNo(String secondaryConsignmentNo){
    this.secondaryConsignmentNo = secondaryConsignmentNo;
    }
    public String getSecondaryConsignmentNo(){
    return this.secondaryConsignmentNo;
    }
    public void setOutResultNo(String outResultNo){
    this.outResultNo = outResultNo;
    }
    public String getOutResultNo(){
    return this.outResultNo;
    }
    public void setOutNoticeNo(String outNoticeNo){
    this.outNoticeNo = outNoticeNo;
    }
    public String getOutNoticeNo(){
    return this.outNoticeNo;
    }
    public void setBusinessNo(String businessNo){
    this.businessNo = businessNo;
    }
    public String getBusinessNo(){
    return this.businessNo;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setExternalOrderNo(String externalOrderNo){
    this.externalOrderNo = externalOrderNo;
    }
    public String getExternalOrderNo(){
    return this.externalOrderNo;
    }
    public void setMergeOrderNo(String mergeOrderNo){
    this.mergeOrderNo = mergeOrderNo;
    }
    public String getMergeOrderNo(){
    return this.mergeOrderNo;
    }
    public void setOrderStatus(Integer orderStatus){
    this.orderStatus = orderStatus;
    }
    public Integer getOrderStatus(){
    return this.orderStatus;
    }
    public void setTransferConsignmentNo(String transferConsignmentNo){
    this.transferConsignmentNo = transferConsignmentNo;
    }
    public String getTransferConsignmentNo(){
    return this.transferConsignmentNo;
    }
    public void setTransferWmsConsignmentNo(String transferWmsConsignmentNo){
    this.transferWmsConsignmentNo = transferWmsConsignmentNo;
    }
    public String getTransferWmsConsignmentNo(){
    return this.transferWmsConsignmentNo;
    }
    public void setParentConsignmentNo(String parentConsignmentNo){
    this.parentConsignmentNo = parentConsignmentNo;
    }
    public String getParentConsignmentNo(){
    return this.parentConsignmentNo;
    }
    public void setParentWmsConsignmentNo(String parentWmsConsignmentNo){
    this.parentWmsConsignmentNo = parentWmsConsignmentNo;
    }
    public String getParentWmsConsignmentNo(){
    return this.parentWmsConsignmentNo;
    }
    public void setPhysicsWarehouseCode(String physicsWarehouseCode){
    this.physicsWarehouseCode = physicsWarehouseCode;
    }
    public String getPhysicsWarehouseCode(){
    return this.physicsWarehouseCode;
    }
    public void setPhysicsWarehouseName(String physicsWarehouseName){
    this.physicsWarehouseName = physicsWarehouseName;
    }
    public String getPhysicsWarehouseName(){
    return this.physicsWarehouseName;
    }
}
