package com.dtyunxi.tcbj.api.dto.constant.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum LogisticDocumentTypeEnum {
    //弃用
    ORIGINAL(1,"原始单据"),
    MERGE(2,"合并订单"),
    IMPORT(3,"手工导入"),

    MERGE_MASTER(4,"合单主单"),
    MERGE_CHILD(5,"合单子单"),
    MERGE_OTHER(6,"其他"),
    ;
    private Integer code;
    private String name;

    LogisticDocumentTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Map<Integer,String> TYPE_MAP = new HashMap<>();
    static {
        LogisticDocumentTypeEnum[] values = LogisticDocumentTypeEnum.values();
        for (LogisticDocumentTypeEnum value : values) {
            Integer code = value.code;
            String name = value.getName();
            TYPE_MAP.put(code,name);
        }
    }
}
