package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOrderReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
* 放行单服务接口
*
* @author 无凡
* @since 2023-05-05
*/
@Api(tags = {"放行单报表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IInspectionReleaseOrderQueryReportApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/inspectionReleaseReportOrder",
        url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleaseOrderQueryReportApi {

    /**
    * 根据id查询放行单
    *
    * @param id 放行单id
    * @return   放行单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询放行单", notes = "根据id查询放行单")
    RestResponse<InspectionReleaseOrderReportRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 放行单分页数据
    *
    * @param filter   放行单查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 放行单分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "放行单分页数据", notes = "根据filter查询条件查询放行单数据，filter=InspectionReleaseOrderReqDto")
    RestResponse<PageInfo<InspectionReleaseOrderReportRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 放行单列表查询
     * @param reqDto 请求接口
     * @return 处理结果
     */
    @PostMapping("/queryByParams")
    @ApiOperation(value = "放行单列表查询", notes = "放行单列表查询")
    RestResponse<List<InspectionReleaseOrderReportRespDto>> queryByParams(@RequestBody InspectionReleaseOrderReportReqDto reqDto);

}
