package com.dtyunxi.tcbj.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Tile </p>
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */
@Data
public class PhysicWarehouseStatisticsExtRespDto implements Serializable {

    @ApiModelProperty(name = "details", value = "统计详情")
    List<PhysicWarehouseStatisticsRespDto> details = Lists.newArrayList();

    /**
     *  入库板数
     */
    @ApiModelProperty(name = "totalInNumber", value = "总入库板数")
    private Long totalInNumber;
    /**
     *  出库板数
     */
    @ApiModelProperty(name = "totalOutNumber", value = "总出库板数")
    private Long totalOutNumber;
    /**
     *  库存板数
     */
    @ApiModelProperty(name = "totalStockNumber", value = "总库存板数")
    private Long totalStockNumber;
    /**
     *  在途板数
     */
    @ApiModelProperty(name = "totalIntransitNumber", value = "总在途板数")
    private Long totalIntransitNumber;

    @ApiModelProperty(name = "zhSurplusTrayNum", value = "珠海仓剩余板数")
    private Long zhSurplusTrayNum = 29285L;
}
