package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailChargingDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 物流计费明细服务
 */
@Api(tags = {"物流计费明细服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IFinLogisticDetailChargingApi",
        name = "tcbj-center-report",
        path = "/v1/finLogisticDetailChargingApi",
        url = "${tcbj.center.report.api:}"
)
public interface IFinLogisticDetailChargingApi {

    @PostMapping("/queryPage")
    @ApiOperation(value = "物流计费明细分页查询", notes = "物流计费明细分页查询")
    RestResponse<PageInfo<FinLogisticDetailChargingDto>> queryPage(@RequestBody FinLogisticDetailChargingDto dto);

    @PostMapping("/queryFlagCount")
    @ApiOperation(value = "物流计费明细异常统计", notes = "物流计费明细异常统计")
    RestResponse<FinLogisticDetailChargingDto> queryFlagCount(@RequestBody FinLogisticDetailChargingDto reqDto);

    @PostMapping("/queryDataCount")
    @ApiOperation(value = "物流计费明细数据统计", notes = "物流计费明细数据统计")
    RestResponse<FinLogisticDetailChargingDto> queryDataCount(@RequestBody FinLogisticDetailChargingDto reqDto);

    @PostMapping("/updateBillingOrg")
    @ApiOperation(value = "修改计费组织", notes = "修改计费组织")
    RestResponse<Void> updateBillingOrg(@RequestBody FinLogisticDetailChargingDto dto);

    @PostMapping("/generateLogisticDetailCharging")
    @ApiOperation(value = "生成人工分摊/内部交易物流计费明细", notes = "生成人工分摊/内部交易物流计费明细")
    RestResponse<Void> generateLogisticDetailCharging(@RequestBody FinLogisticDetailChargingDto dto);
}
