package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * 计费费用生成请求DTO
 *
 * @author jiejun
 */
@ApiModel(value = "FeeGenerateReqDto", description = "计费费用生成请求DTO")
@Getter
@Setter
@ToString
public class FeeGenerateReqDto extends RequestDto {

    @ApiModelProperty(name = "feeType", value = "费用模块")
    private String feeType;

    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份，yyyy-mm")
    private String bookkeepingMonth;

    @ApiModelProperty(name = "taskId", value = "任务ID")
    private String taskId;

    @ApiModelProperty(name = "menuModule", value = "菜单模块")
    private String menuModule;

    @ApiModelProperty(name = "startDate", value = "开始时间，根据记者月份转化yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty(name = "endDate", value = "结束时间，根据记者月份转化yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty(name = "costTypeList", value = "计费类型集合")
    private List<String> costTypeList;

    @ApiModelProperty(name = "outPhysicsWarehouseCodeList", value = "出库物理仓编码集合")
    private List<String> outPhysicsWarehouseCodeList;

    @ApiModelProperty(name = "outPhysicsWarehouseNameList", value = "出库物理仓名称集合")
    private List<String> outPhysicsWarehouseNameList;

    @ApiModelProperty(name = "logisticCompanyList", value = "物流公司名称集合")
    private List<String> logisticCompanyList;

    @ApiModelProperty(name = "logisticCompanyCodeList", value = "物流公司编码集合")
    private List<String> logisticCompanyCodeList;

    @ApiModelProperty(name = "transportTypeList", value = "承运方式集合")
    private List<String> transportTypeList;

    @ApiModelProperty(name = "ifRefreshOriginal", value = "是否刷新原始与计费明细，默认是")
    private Boolean ifRefreshOriginal = true;

    @ApiModelProperty(name = "refreshOriginalDetail", value = "是否刷新原始明细，默认是")
    private Boolean refreshOriginalDetail = true;

}
