package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumChargingRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 保费计费明细表服务接口
 */
@Api(tags = {"保费计费明细表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IReInsurancePremiumDetailQueryApi",
        name = "tcbj-center-report",
        path = "/v1/reInsurancePremiumCharging",
        url = "${tcbj.center.report.api:}"
)
public interface IReInsurancePremiumChargingQueryApi {

    /**
     * 根据id查询保费计费明细表
     *
     * @param id 保费计费明细表id
     * @return 保费计费明细表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询保费计费明细表", notes = "根据id查询保费计费明细表")
    RestResponse<ReInsurancePremiumChargingRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 保费计费明细表分页数据
     *
     * @param filter   保费计费明细表查询条件
     * @return 保费计费明细表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "保费计费明细表分页数据", notes = "根据filter查询条件查询保费计费明细表数据，filter=ReInsurancePremiumReqDto")
    RestResponse<PageInfo<ReInsurancePremiumChargingRespDto>> queryByPage(@RequestBody ReInsurancePremiumChargingReqDto filter);

    @PostMapping("/queryFlagCount")
    @ApiOperation(value = "保费计费明细异常统计", notes = "保费计费明细异常统计")
    RestResponse<ReInsurancePremiumChargingRespDto> queryFlagCount(@RequestBody ReInsurancePremiumChargingReqDto reqDto);
}
