package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 成本中心维护服务接口
*
* @author longde
* @since 2022-08-17
*/
@Api(tags = {"成本中心维护服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ICostCenterApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/costCenter",
    url = "${tcbj.center.report.api:}"
)
public interface ICostCenterApi {

/**
* 新增成本中心维护
*
* @param addReqDto 成本中心维护请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增成本中心维护", notes = "新增成本中心维护")
RestResponse<Long> addCostCenter(@RequestBody CostCenterReqDto addReqDto);

    /**
    * 修改成本中心维护
    *
    * @param modifyReqDto 成本中心维护请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改成本中心维护", notes = "修改成本中心维护")
    RestResponse<Void> modifyCostCenter(@RequestBody CostCenterReqDto modifyReqDto);

    /**
    * 删除成本中心维护
    *
    * @param ids        成本中心维护删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除成本中心维护", notes = "删除成本中心维护")
    RestResponse<Void> removeCostCenter(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
