/**
 * @(#) PurchaseOrderVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 采购订单实体
 */
@Data
@ApiModel(value = "PurchaseOrderVO", description = "采购订单实体")
public class PurchaseOrderVO {

  @ApiModelProperty(name = "id", value = "唯一id")
  @JsonProperty("id")
  private Long id;

  /**
   * 平台单号(来源于第三方系统)
   */
  @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
  private String platformOrderNo;

  @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的计划类单据号")
  private String orderNo;

  /**
   * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
   */
  @ApiModelProperty(name = "orderType", value = "单据类型")
  private String orderType;

  @ApiModelProperty(name = "estimatedTime", value = "预计到货时间")
  private Date estimatedTime;
  /**
   * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
   */
  @ApiModelProperty(name = "businessType", value = "业务类型")
  private String businessType;
  /**
   * 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起
   */
  @ApiModelProperty(name = "orderStatus", value = "单据状态")
  private String orderStatus;
  /**
   * 收货仓库ID
   */
  @ApiModelProperty(name = "receiveWarehouseId", value = "收货仓库ID")
  private Long receiveWarehouseId;
  /**
   * 收货仓库编码
   */
  @ApiModelProperty(name = "receiveWarehouseCode", value = "收货仓库编码")
  private String receiveWarehouseCode;
  /**
   * 收货仓库名称
   */
  @ApiModelProperty(name = "receiveWarehouseName", value = "收货仓库名称")
  private String receiveWarehouseName;
  /**
   * 供应商ID
   */
  @ApiModelProperty(name = "supplierId", value = "供应商ID")
  private Long supplierId;
  /**
   * 供应商编码
   */
  @ApiModelProperty(name = "supplierCode", value = "供应商编码")
  private String supplierCode;
  /**
   * 供应商名称
   */
  @ApiModelProperty(name = "supplierName", value = "供应商名称")
  private String supplierName;
  /**
   * 总数量
   */
  @ApiModelProperty(name = "totalQuantity", value = "总数量")
  private BigDecimal totalQuantity;
  /**
   * 已入总数量
   */
  @ApiModelProperty(name = "doneInQuantity", value = "已入总数量")
  private BigDecimal doneInQuantity;
  /**
   * 组织ID
   */
  @ApiModelProperty(name = "organizationId", value = "组织ID")
  private Long organizationId;
  /**
   * 组织名称
   */
  @ApiModelProperty(name = "organizationName", value = "组织名称")
  private String organizationName;
  /**
   * 创建人
   */
  @ApiModelProperty(name = "createPerson", value = "创建人")
  private String createPerson;

  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonProperty("createTime")
  private Date createTime;

  private Long createTimeLong;

  @ApiModelProperty(name = "bizDate", value = "业务时间")
  private Date bizDate;
}

