package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class LogisticStatisticReqDto {

    //开始时间
    private String startTime;

    //结束时间
    private String endTime;

    private String relevanceNo;

    private String documentNo;

    private List<String> documentNos;

    private String warehouseCode;

    private List<String> warehouseCodeNameList;

    private String shippingCompanyCode;

    private String shippingType;

    @ApiModelProperty(name = "contractId", value = "合同id")
    private Long contractId;

    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;

    @ApiModelProperty(name = "outResultNo", value = "出库结果单单号")
    private String outResultNo;

    @ApiModelProperty(name = "linkDailyReportIds", value = "每日发货报表ID集合")
    private List<Long> linkDailyReportIds;

    @ApiModelProperty(name = "warehouseCodeList", value = "物理仓编码集合")
    private List<String> warehouseCodeList;

    @ApiModelProperty(name = "logisticCodeList", value = "物流公司编码集合")
    private List<String> logisticCodeList;

    @ApiModelProperty(name = "transportTypeList", value = "承运方式集合")
    private List<String> transportTypeList;

    @ApiModelProperty(name = "costTypeList", value = "计费类型集合")
    private List<String> costTypeList;

    @ApiModelProperty(name = "taskId", value = "任务ID")
    private String taskId;

    @ApiModelProperty(name = "if_apportion", value = "是否分摊；1是，0否")
    private Integer ifApportion;

}
