package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 保费计费明细表服务接口
 */
@Api(tags = {"保费计费明细表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IReInsurancePremiumDetailApi",
        name = "tcbj-center-report",
        path = "/v1/reInsurancePremiumCharging",
        url = "${tcbj.center.report.api:}"
)
public interface IReInsurancePremiumChargingApi {

    @PostMapping("")
    @ApiOperation(value = "新增保费明细表", notes = "新增保费明细表")
    RestResponse<Long> addReInsurancePremiumCharging(@RequestBody ReInsurancePremiumChargingReqDto addReqDto);

    @PutMapping("")
    @ApiOperation(value = "修改保费明细表", notes = "修改保费明细表")
    RestResponse<Void> modifyReInsurancePremium(@RequestBody ReInsurancePremiumChargingReqDto modifyReqDto);

    @PostMapping("/updateCostBelongOrg")
    @ApiOperation(value = "修改计费归属组织", notes = "修改计费归属组织")
    RestResponse<Void> updateCostBelongOrg(@RequestBody ReInsurancePremiumChargingReqDto reqDto);
}
