package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "LogisticsInfoRespDto", description = "物流流水信息")
public class LogisticsInfoRespDto {
    @ApiModelProperty(name="consignmentNo", value = "物流单号")
    private String consignmentNo;
    @ApiModelProperty(name="deliveryWay", value = "发货方式")
    private String deliveryWay;
    @ApiModelProperty(name="carrierName", value = "物流公司")
    private String carrierName;
    @ApiModelProperty(name="detailList", value = "物流明细列表")
    private List<LogisticsInfoDetail> detailList;

    @Data
    @ApiModel(value = "LogisticsInfoDetail", description = "物流明细")
    public static class LogisticsInfoDetail{

        @ApiModelProperty(name = "id", value = "主键id")
        private Long id;
        @ApiModelProperty(name = "carrierId", value = "承运商序列号，唯一索引")
        private String carrierId;
        @ApiModelProperty(name = "type", value = "类型： 1物流，2快递")
        private Integer type;
        @ApiModelProperty(name = "cspNo", value = "CSP客户订单号")
        private String cspNo;
        @ApiModelProperty(name = "pcpNo", value = "PCP订单号")
        private String pcpNo;
        @ApiModelProperty(name = "easNo", value = "EAS订单号")
        private String easNo;
        @ApiModelProperty(name = "carrierCode", value = "承运商代码")
        private String carrierCode;
        @ApiModelProperty(name = "carrierName", value = "承运商名称")
        private String carrierName;
        @ApiModelProperty(name = "carrierNo", value = "承运商单号")
        private String carrierNo;
        @ApiModelProperty(name = "carrierType", value = "承运方式")
        private String carrierType;
        @ApiModelProperty(name = "consignmentNo", value = "托运单号")
        private String consignmentNo;
        @ApiModelProperty(name = "ocsConsignmentNo", value = "OCS运单号")
        private String ocsConsignmentNo;
        @ApiModelProperty(name = "secondaryConsignmentNo", value = "副托运单号")
        private String secondaryConsignmentNo;
        @ApiModelProperty(name = "status", value = "状态 0:提交，1：捡货，2：发货，3：在途，4.签收")
        private String status;
        @ApiModelProperty(name = "orgName", value = "")
        private String orgName;
        @ApiModelProperty(name = "deliveStartTime", value = "捡货时间")
        private Date deliveStartTime;
        @ApiModelProperty(name = "shipTime", value = "发货时间")
        private Date shipTime;
        @ApiModelProperty(name = "expectedArrivalTime", value = "预计到达时间")
        private Date expectedArrivalTime;
        @ApiModelProperty(name = "actualArrivalTime", value = "实际到达时间")
        private Date actualArrivalTime;
        @ApiModelProperty(name = "cargoDamageNum", value = "货损数量")
        private Integer cargoDamageNum;
        @ApiModelProperty(name = "remark", value = "备注")
        private String remark;
        @ApiModelProperty(name = "operTime", value = "操作时间")
        private Date operTime;
        @ApiModelProperty(name = "operAddr", value = "操作地点")
        private String operAddr;
        @ApiModelProperty(name = "operPerson", value = "操作人")
        private String operPerson;
        @ApiModelProperty(name = "operInfo", value = "操作详情")
        private String operInfo;
        @ApiModelProperty(name = "pictureUrl", value = "回单图片地址,如果有多张图，可以用逗号分隔")
        private String pictureUrl;
        @ApiModelProperty(name = "organizationId", value = "组织ID")
        private Long organizationId;
        @ApiModelProperty(name = "organizationName", value = "组织名称")
        private String organizationName;
//        @ApiModelProperty(name="status", value = "物流状态： 0:提交，1：捡货，2：发货，3：在途，4.签收")
//        private String status;
//        @ApiModelProperty(name="operTime", value = "操作时间")
//        private Date operTime;
//        @ApiModelProperty(name="operInfo", value = "操作信息")
//        private String operInfo;
    }

}
