package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "SaleIntransitEarlyWarningQueryReqDto", description = "销售在途预警报表查询")
public class SaleIntransitEarlyWarningQueryReqDto {

    @ApiModelProperty(name ="orderNo",value = "订单号")
    private String orderNo;
    @ApiModelProperty(name ="orderNoList",value = "订单号集合")
    private List<String> orderNoList;

    @ApiModelProperty(name ="saleOrderNo",value = "内部销售订单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "easOrderNo",value = "eas单号")
    private String easOrderNo;

    @ApiModelProperty(name ="orderLevel",value = "订单级别（0原、1主、2子）")
    private Integer orderLevel;

    @ApiModelProperty(name ="orderType",value = "订单类型 ")
    private String orderType;
    @ApiModelProperty(name ="orderTypeList",value = "订单类型集合 ")
    private List<String> orderTypeList;

    @ApiModelProperty(name = "orderStatus", value = "订单状态 ERROR :异常，WAIT_PICK：已配货， WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 ")
    private String orderStatus;

    @ApiModelProperty(name = "orderStatusError", value = "订单状态 ERROR :异常 ")
    private String orderStatusError;

    @ApiModelProperty(name = "secondOrderStatus", value = "订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库")
    private String secondOrderStatus;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "refCarLicenseNo", value = "关联的车牌信息")
    private String refCarLicenseNo;

    @ApiModelProperty(name = "refTransferOrderNo", value = "关联的调拨单号")
    private String refTransferOrderNo;

    @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
    private String logicalWarehouseName;
    @ApiModelProperty(name="logicalWarehouseCodeList", value = "逻辑仓编码集合")
    private List<String> logicalWarehouseCodeList;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;
    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓编码集合")
    private List<String> physicsWarehouseCodeList;

    @ApiModelProperty( name = "allowSplitFlag",value = "是否接受拆单 0-否 1-是")
    private Integer allowSplitFlag;

    @ApiModelProperty(name ="customerName",value = "客户名称")
    private String customerName;

    @ApiModelProperty(name ="receiveName",value = "收件人姓名")
    private String receiveName;

    @ApiModelProperty(name ="receivePhone",value = "收件人电话")
    private String receivePhone;

    @ApiModelProperty(name = "receiveAddress", value = "地址、区域实体")
    private String receiveAddress;


    @ApiModelProperty(name="pageSize", required = true, value = "分页大小")
    private Integer pageSize;


    @ApiModelProperty(name="pageNum", required = true, value = "当前分页")
    private Integer pageNum;

}
