package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>Tile </p>
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */

public class DeliveryTimeLimitExtRespDto implements Serializable {

    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    private String documentNo;

    @ApiModelProperty(name = "pushTime", value = "推送给仓库时间")
    private Date pushTime;

    @ApiModelProperty(name = "warehouseTime", value = "仓库发货返回时间")
    private Date warehouseTime;

    @ApiModelProperty(name = "deliveryTime", value = "发货时效(天)")
    private Double deliveryTime = 0D;

    @ApiModelProperty(name = "avDeliveryTime", value = "平均发货时效(天)")
    private Double avDeliveryTime = 0D;

    @ApiModelProperty(name = "proportion", value = "占比")
    private String proportion;

    @ApiModelProperty(name = "orderQuantity", value = "订单数量")
    private Integer orderQuantity;

    public Integer getOrderQuantity() {
        return orderQuantity;
    }

    public void setOrderQuantity(Integer orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    public Double getAvDeliveryTime() {
        return avDeliveryTime;
    }

    public void setAvDeliveryTime(Double avDeliveryTime) {
        this.avDeliveryTime = avDeliveryTime;
    }


    public String getProportion() {
        return proportion;
    }

    public void setProportion(String proportion) {
        this.proportion = proportion;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Date getWarehouseTime() {
        return warehouseTime;
    }

    public void setWarehouseTime(Date warehouseTime) {
        this.warehouseTime = warehouseTime;
    }

    /**
     *
     * @return 返回毫秒
     */
    public Double getDeliveryTime() {
        if (this.getPushTime() != null && this.getWarehouseTime() != null) {
            Long pushTime = this.getPushTime().getTime();
            Long warehouseTime = this.getWarehouseTime().getTime();
//            double v = (warehouseTime - pushTime) / (60 * 60 * 24 * 1000);
            String str = String.format("%s", warehouseTime - pushTime);
            return Double.parseDouble(str);
        }
        return deliveryTime;
    }

    public void setDeliveryTime(Double deliveryTime) {
        this.deliveryTime = deliveryTime;
    }
}
