package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 质检数据Eo对象
*
* @author 天泽
* @since 2022-08-09
*/
@ApiModel(value = "QualityInspectionDataRespDto", description = "质检数据Eo对象")
public class QualityInspectionDataRespDto extends BaseRespDto{

    /**
    *  主键
    */
    @ApiModelProperty(name = "externalId", value = "主键")
    private String externalId;
    /**
    *  委托单号
    */
    @ApiModelProperty(name = "externalNo", value = "委托单号")
    private String externalNo;
    /**
    *  委托来源EAS MES OA）
    */
    @ApiModelProperty(name = "sourceFrom", value = "委托来源EAS MES OA）")
    private String sourceFrom;
    /**
    *  QA补充信息
    */
    @ApiModelProperty(name = "externalRemark", value = "QA补充信息")
    private String externalRemark;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     *  旧商品长编码
     */
    @ApiModelProperty(name = "oldLongCode", value = "旧商品长编码")
    private String oldLongCode;

    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  商品合格数量
    */
    @ApiModelProperty(name = "qualifiedNum", value = "商品合格数量")
    private String qualifiedNum;
    /**
    *  商品不合格数量
    */
    @ApiModelProperty(name = "unqualifiedNum", value = "商品不合格数量")
    private String unqualifiedNum;
    /**
    *  商品放行数量
    */
    @ApiModelProperty(name = "releaseNum", value = "商品放行数量")
    private String releaseNum;
    /**
    *  报告建立时间
    */
    @ApiModelProperty(name = "reportTime", value = "报告建立时间")
    private String reportTime;
    /**
    *  质检报告 合格、不合格
    */
    @ApiModelProperty(name = "reportResult", value = "质检报告 合格、不合格")
    private String reportResult;
    /**
    *  url
    */
    @ApiModelProperty(name = "reportResultUrl", value = "url")
    private String reportResultUrl;
    /**
    *  WMS状态
    */
    @ApiModelProperty(name = "wmsStatus", value = "WMS状态")
    private String wmsStatus;
    /**
    *  采样类型
    */
    @ApiModelProperty(name = "sampleType", value = "采样类型")
    private String sampleType;
    /**
    *  系统类型
    */
    @ApiModelProperty(name = "systemType", value = "系统类型")
    private String systemType;

    @ApiModelProperty(name = "source", value = "数据来源1同步，2导入")
    private String source;

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUniqueKey(){
        return  String.format("%s_%s", this.getBatch(), this.getLongCode());
    }

    public void setExternalId(String externalId){
    this.externalId = externalId;
    }
    public String getExternalId(){
    return this.externalId;
    }
    public void setExternalNo(String externalNo){
    this.externalNo = externalNo;
    }
    public String getExternalNo(){
    return this.externalNo;
    }
    public void setSourceFrom(String sourceFrom){
    this.sourceFrom = sourceFrom;
    }
    public String getSourceFrom(){
    return this.sourceFrom;
    }
    public void setExternalRemark(String externalRemark){
    this.externalRemark = externalRemark;
    }
    public String getExternalRemark(){
    return this.externalRemark;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setQualifiedNum(String qualifiedNum){
    this.qualifiedNum = qualifiedNum;
    }
    public String getQualifiedNum(){
    return this.qualifiedNum;
    }
    public void setUnqualifiedNum(String unqualifiedNum){
    this.unqualifiedNum = unqualifiedNum;
    }
    public String getUnqualifiedNum(){
    return this.unqualifiedNum;
    }
    public void setReleaseNum(String releaseNum){
    this.releaseNum = releaseNum;
    }
    public String getReleaseNum(){
    return this.releaseNum;
    }
    public void setReportTime(String reportTime){
    this.reportTime = reportTime;
    }
    public String getReportTime(){
    return this.reportTime;
    }
    public void setReportResult(String reportResult){
    this.reportResult = reportResult;
    }
    public String getReportResult(){
    return this.reportResult;
    }
    public void setReportResultUrl(String reportResultUrl){
    this.reportResultUrl = reportResultUrl;
    }
    public String getReportResultUrl(){
    return this.reportResultUrl;
    }
    public void setWmsStatus(String wmsStatus){
    this.wmsStatus = wmsStatus;
    }
    public String getWmsStatus(){
    return this.wmsStatus;
    }
    public void setSampleType(String sampleType){
    this.sampleType = sampleType;
    }
    public String getSampleType(){
    return this.sampleType;
    }
    public void setSystemType(String systemType){
    this.systemType = systemType;
    }
    public String getSystemType(){
    return this.systemType;
    }

    public String getOldLongCode() {
        return oldLongCode;
    }

    public void setOldLongCode(String oldLongCode) {
        this.oldLongCode = oldLongCode;
    }
}
